/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class RLEEncoder
implements Encoder {
    private final int pixelSize;

    RLEEncoder(int n) {
        Validate.isTrue((n % 8 == 0 ? 1 : 0) != 0, (String)"Depth must be a multiple of bytes (8 bits)");
        this.pixelSize = n / 8;
    }

    public void encode(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        this.encode(outputStream, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.remaining());
    }

    private void encode(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2 - this.pixelSize;
        int n5 = n4 - this.pixelSize;
        while (n3 <= n4) {
            int n6;
            for (n6 = 1; n6 < 127 && n3 < n4 && this.equalPixel(byArray, n3, n3 + this.pixelSize); n3 += this.pixelSize, ++n6) {
            }
            if (n6 > 1) {
                outputStream.write(0x80 | n6 - 1);
                outputStream.write(byArray, n3, this.pixelSize);
                n3 += this.pixelSize;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 127 && (n3 < n4 && !this.equalPixel(byArray, n3, n3 + this.pixelSize) || n3 < n5 && !this.equalPixel(byArray, n3, n3 + 2 * this.pixelSize)); n3 += this.pixelSize, ++n6) {
            }
            if (n3 == n4 && n6 > 0 && n6 < 127) {
                n3 += this.pixelSize;
                ++n6;
            }
            if (n6 > 0) {
                outputStream.write(n6 - 1);
                outputStream.write(byArray, n7, n6 * this.pixelSize);
            }
            if (n3 != n4 || n6 > 0 && n6 < 127) continue;
            outputStream.write(0);
            outputStream.write(byArray, n3, this.pixelSize);
            n3 += this.pixelSize;
        }
    }

    private boolean equalPixel(byte[] byArray, int n, int n2) {
        for (int i = 0; i < this.pixelSize; ++i) {
            if (byArray[n + i] == byArray[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

