/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import com.icafe4j.util.LeftHeapNode;
import java.lang.reflect.Array;

public class LeftistHeap<E extends Comparable<? super E>> {
    private LeftHeapNode<E> root = null;
    private int size;

    public void merge(LeftistHeap<E> leftistHeap) {
        if (this == leftistHeap) {
            return;
        }
        this.root = LeftistHeap.merge(this.root, leftistHeap.root);
        this.size += leftistHeap.getSize();
        leftistHeap.root = null;
    }

    private static <T extends Comparable<? super T>> LeftHeapNode<T> merge(LeftHeapNode<T> leftHeapNode, LeftHeapNode<T> leftHeapNode2) {
        LeftHeapNode<Object> leftHeapNode3;
        if (leftHeapNode == null) {
            return leftHeapNode2;
        }
        if (leftHeapNode2 == null) {
            return leftHeapNode;
        }
        if (((Comparable)leftHeapNode.element).compareTo(leftHeapNode2.element) > 0) {
            leftHeapNode3 = leftHeapNode;
            leftHeapNode = leftHeapNode2;
            leftHeapNode2 = leftHeapNode3;
        }
        if (leftHeapNode.left == null) {
            leftHeapNode.left = leftHeapNode2;
        } else {
            leftHeapNode.right = LeftistHeap.merge(leftHeapNode.right, leftHeapNode2);
            if (leftHeapNode.left.npl < leftHeapNode.right.npl) {
                leftHeapNode3 = leftHeapNode.left;
                leftHeapNode.left = leftHeapNode.right;
                leftHeapNode.right = leftHeapNode3;
            }
            leftHeapNode.npl = leftHeapNode.right.npl + 1;
        }
        return leftHeapNode;
    }

    public synchronized void insert(E e) {
        this.root = LeftistHeap.merge(this.root, new LeftHeapNode<E>(e));
        ++this.size;
    }

    public synchronized E findMin() {
        return (E)(this.root == null ? null : (Comparable)this.root.element);
    }

    public synchronized E deleteMin() {
        if (this.root == null) {
            return null;
        }
        Comparable comparable = (Comparable)this.root.element;
        this.root = LeftistHeap.merge(this.root.left, this.root.right);
        --this.size;
        return (E)comparable;
    }

    public synchronized E[] toArray(E[] objectArray, boolean bl) {
        int n = this.size;
        if (objectArray.length < n) {
            objectArray = (Comparable[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.deleteMin();
            }
        } else {
            int n2 = n;
            while (n2-- > 0) {
                objectArray[n2] = this.deleteMin();
            }
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public synchronized boolean isEmpty() {
        return this.root == null;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void makeEmpty() {
        this.root = null;
    }

    public static void main(String[] stringArray) {
        int n = 100;
        LeftistHeap<Integer> leftistHeap = new LeftistHeap<Integer>();
        LeftistHeap<Integer> leftistHeap2 = new LeftistHeap<Integer>();
        int n2 = 37;
        System.out.println("Checking... (no more output means success)");
        n2 = 37;
        while (n2 != 0) {
            if (n2 % 2 == 0) {
                leftistHeap2.insert(n2);
            } else {
                leftistHeap.insert(n2);
            }
            n2 = (n2 + 37) % n;
        }
        leftistHeap.merge(leftistHeap2);
        for (n2 = 1; n2 < n; ++n2) {
            if ((Integer)leftistHeap.deleteMin() == n2) continue;
            System.out.println("Oops! " + n2);
        }
    }
}

