/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.test;

import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.gif.GIFFrame;
import com.icafe4j.image.gif.GIFTweaker;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.JPGOptions;
import com.icafe4j.image.options.PNGOptions;
import com.icafe4j.image.options.TIFFOptions;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.writer.GIFWriter;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.test.TestBase;
import com.icafe4j.util.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class TestGIFTweaker
extends TestBase {
    public static void main(String[] stringArray) throws Exception {
        new TestGIFTweaker().test(stringArray);
    }

    @Override
    public void test(String ... stringArray) throws Exception {
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream("NEW.gif");
        File[] fileArray = FileUtils.listFilesMatching(new File(stringArray[1]), stringArray[2]);
        GIFFrame[] gIFFrameArray = new GIFFrame[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
            BufferedImage bufferedImage = javax.imageio.ImageIO.read(fileInputStream);
            gIFFrameArray[i] = new GIFFrame(bufferedImage, 100, 2);
            fileInputStream.close();
        }
        ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
        long l = System.currentTimeMillis();
        GIFWriter gIFWriter = new GIFWriter();
        gIFWriter.setImageParam(imageParamBuilder.applyDither(true).build());
        GIFTweaker.prepareForWrite(gIFWriter, fileOutputStream, 0, 0);
        for (int i = 0; i < gIFFrameArray.length; ++i) {
            GIFTweaker.writeFrame(gIFWriter, (OutputStream)fileOutputStream, gIFFrameArray[i]);
        }
        GIFTweaker.finishWrite(fileOutputStream);
        long l2 = System.currentTimeMillis();
        this.logger.info("time used: {}ms", (Object)(l2 - l));
        ImageWriter imageWriter = ImageIO.getWriter(ImageType.GIF);
        ImageType imageType = imageWriter.getImageType();
        switch (imageType) {
            case TIFF: {
                object = new TIFFOptions();
                ((TIFFOptions)object).setApplyPredictor(true);
                ((TIFFOptions)object).setTiffCompression(TiffFieldEnum.Compression.LZW);
                ((TIFFOptions)object).setJPEGQuality(60);
                ((TIFFOptions)object).setDeflateCompressionLevel(6);
                imageParamBuilder.imageOptions((ImageOptions)object);
                break;
            }
            case PNG: {
                PNGOptions pNGOptions = new PNGOptions();
                pNGOptions.setApplyAdaptiveFilter(true);
                pNGOptions.setCompressionLevel(6);
                pNGOptions.setFilterType(0);
                imageParamBuilder.imageOptions(pNGOptions);
                break;
            }
            case JPG: {
                JPGOptions jPGOptions = new JPGOptions();
                jPGOptions.setQuality(90);
                imageParamBuilder.imageOptions(jPGOptions);
                break;
            }
        }
        imageWriter.setImageParam(imageParamBuilder.applyDither(true).hasAlpha(true).build());
        object = new FileInputStream(stringArray[0]);
        GIFTweaker.splitAnimatedGIF((InputStream)object, imageWriter, "split");
        ((FileInputStream)object).close();
        object = new FileInputStream("images/tmp-00.gif");
        fileOutputStream = new FileOutputStream("tmp-00-comment-inserted.gif");
        GIFTweaker.insertComments((InputStream)object, fileOutputStream, Arrays.asList("I am a piggy!", "I can fly!"));
        ((FileInputStream)object).close();
        fileOutputStream.close();
    }
}

