/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.io;

import com.icafe4j.io.WriteStrategy;
import com.icafe4j.io.WriteStrategyMM;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RandomAccessOutputStream
extends OutputStream
implements DataOutput {
    private WriteStrategy strategy = WriteStrategyMM.getInstance();
    protected OutputStream dist;
    protected boolean closed;

    protected RandomAccessOutputStream(OutputStream outputStream) {
        this.dist = outputStream;
    }

    @Override
    public void close() throws IOException {
        long l;
        long l2 = this.getFlushPos();
        if (l2 < (l = this.getLength())) {
            this.seek(l2);
            this.writeToStream(l - l2);
        }
    }

    public abstract void shallowClose() throws IOException;

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public abstract void disposeBefore(long var1) throws IOException;

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public short getEndian() {
        return this.strategy instanceof WriteStrategyMM ? (short)19789 : 18761;
    }

    public abstract long getFlushPos();

    public abstract long getLength();

    public abstract long getStreamPointer();

    public abstract void reset();

    public abstract void seek(long var1) throws IOException;

    public void setWriteStrategy(WriteStrategy writeStrategy) {
        this.strategy = writeStrategy;
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        new DataOutputStream(this).writeBytes(string);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeShort(c);
        }
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeInt(byArray, 0, n);
        this.write(byArray, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        byte[] byArray = new byte[8];
        this.strategy.writeLong(byArray, 0, l);
        this.write(byArray, 0, 8);
    }

    public final void writeS15Fixed16Number(float f) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeS15Fixed16Number(byArray, 0, f);
        this.write(byArray, 0, 4);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        byte[] byArray = new byte[2];
        this.strategy.writeShort(byArray, 0, n);
        this.write(byArray, 0, 2);
    }

    public abstract void writeToStream(long var1) throws IOException;

    public final void writeU16Fixed16Number(float f) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeU16Fixed16Number(byArray, 0, f);
        this.write(byArray, 0, 4);
    }

    public final void writeU8Fixed8Number(float f) throws IOException {
        byte[] byArray = new byte[2];
        this.strategy.writeU8Fixed8Number(byArray, 0, f);
        this.write(byArray, 0, 2);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        new DataOutputStream(this).writeUTF(string);
    }
}

