/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMPWriter
extends ImageWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPWriter.class);
    private BitmapHeader bitmapHeader;

    public BMPWriter() {
    }

    public BMPWriter(ImageParam imageParam) {
        super(imageParam);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.BMP;
    }

    @Override
    protected void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        if (this.getImageParam().getColorType() == ImageColorType.INDEXED) {
            this.write256ColorBitmap(nArray, n, n2, outputStream);
        } else {
            this.writeTrueColorBitmap(nArray, n, n2, outputStream);
        }
    }

    private void write256ColorBitmap(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        int n3;
        ImageParam imageParam = this.getImageParam();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n6 = 4 - n % 4;
        if (n6 == 4) {
            n6 = 0;
        }
        int n7 = n + n6;
        byte[] byArray = new byte[1024];
        LOGGER.info("Saving as 256 bits bitmap color image!");
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.imageWidth = n;
        this.bitmapHeader.imageHeight = n2;
        this.bitmapHeader.bitCount = (short)8;
        this.bitmapHeader.compression = 0;
        this.bitmapHeader.imageSize = n7 * n2;
        this.bitmapHeader.fileSize += this.bitmapHeader.imageSize;
        this.bitmapHeader.dataOffSet += 1024;
        this.bitmapHeader.colorsUsed = 256;
        this.bitmapHeader.colorsImportant = 256;
        this.bitmapHeader.writeHeader(outputStream);
        byte[] byArray2 = new byte[n * n2];
        int[] nArray2 = new int[256];
        if (imageParam.isApplyDither()) {
            if (imageParam.getDitherMethod() == DitherMethod.FLOYD_STEINBERG) {
                IMGUtils.reduceColorsDiffusionDither(imageParam.getQuantMethod(), nArray, n, n2, 8, byArray2, nArray2);
            } else {
                IMGUtils.reduceColorsOrderedDither(imageParam.getQuantMethod(), nArray, n, n2, 8, byArray2, nArray2, imageParam.getDitherMatrix());
            }
        } else {
            IMGUtils.reduceColors(imageParam.getQuantMethod(), nArray, 8, byArray2, nArray2, false);
        }
        for (n3 = 0; n3 < 256; ++n3) {
            byArray[n4++] = (byte)(nArray2[n3] & 0xFF);
            byArray[n4++] = (byte)(nArray2[n3] >> 8 & 0xFF);
            byArray[n4++] = (byte)(nArray2[n3] >> 16 & 0xFF);
            byArray[n4++] = -1;
        }
        outputStream.write(byArray, 0, 1024);
        byArray = new byte[n7];
        for (n3 = 1; n3 <= n2; ++n3) {
            n4 = 0;
            n5 = n * (n2 - n3);
            for (int i = 0; i < n; ++i) {
                byArray[n4++] = byArray2[n5++];
            }
            outputStream.write(byArray, 0, n7);
        }
        outputStream.close();
    }

    private void writeTrueColorBitmap(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n5 = 4 - n * 3 % 4;
        if (n5 == 4) {
            n5 = 0;
        }
        int n6 = n * 3 + n5;
        byte[] byArray = new byte[n6];
        LOGGER.info("Saving as 24 bits bitmap color image!");
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.imageWidth = n;
        this.bitmapHeader.imageHeight = n2;
        this.bitmapHeader.bitCount = (short)24;
        this.bitmapHeader.compression = 0;
        this.bitmapHeader.imageSize = n6 * n2;
        this.bitmapHeader.fileSize += this.bitmapHeader.imageSize;
        this.bitmapHeader.colorsUsed = 0;
        this.bitmapHeader.colorsImportant = 0;
        this.bitmapHeader.writeHeader(outputStream);
        for (int i = 1; i <= n2; ++i) {
            n3 = 0;
            n4 = n * (n2 - i);
            for (int j = 0; j < n; ++j) {
                byArray[n3++] = (byte)(nArray[n4] & 0xFF);
                byArray[n3++] = (byte)(nArray[n4] >> 8 & 0xFF);
                byArray[n3++] = (byte)(nArray[n4++] >> 16 & 0xFF);
            }
            outputStream.write(byArray, 0, n6);
        }
        outputStream.close();
    }

    private static class BitmapHeader {
        final byte[] signature = new byte[]{66, 77};
        int fileSize = 54;
        final short reserved1 = 0;
        final short reserved2 = 0;
        int dataOffSet = 54;
        final int infoHeaderLen = 40;
        int imageWidth;
        int imageHeight;
        final short planes = 1;
        short bitCount;
        int compression;
        int imageSize;
        int xResolution = 0;
        int yResolution = 0;
        int colorsUsed;
        int colorsImportant;

        private BitmapHeader() {
        }

        void writeHeader(OutputStream outputStream) throws Exception {
            byte[] byArray = new byte[]{this.signature[0], this.signature[1], (byte)(this.fileSize & 0xFF), (byte)(this.fileSize >> 8 & 0xFF), (byte)(this.fileSize >> 16 & 0xFF), (byte)(this.fileSize >> 24 & 0xFF), 0, 0, 0, 0, (byte)(this.dataOffSet & 0xFF), (byte)(this.dataOffSet >> 8 & 0xFF), (byte)(this.dataOffSet >> 16 & 0xFF), (byte)(this.dataOffSet >> 24 & 0xFF), 40, 0, 0, 0, (byte)(this.imageWidth & 0xFF), (byte)(this.imageWidth >> 8 & 0xFF), (byte)(this.imageWidth >> 16 & 0xFF), (byte)(this.imageWidth >> 24 & 0xFF), (byte)(this.imageHeight & 0xFF), (byte)(this.imageHeight >> 8 & 0xFF), (byte)(this.imageHeight >> 16 & 0xFF), (byte)(this.imageHeight >> 24 & 0xFF), 1, 0, (byte)(this.bitCount & 0xFF), (byte)(this.bitCount >> 8 & 0xFF), (byte)(this.compression & 0xFF), (byte)(this.compression >> 8 & 0xFF), (byte)(this.compression >> 16 & 0xFF), (byte)(this.compression >> 24 & 0xFF), (byte)(this.imageSize & 0xFF), (byte)(this.imageSize >> 8 & 0xFF), (byte)(this.imageSize >> 16 & 0xFF), (byte)(this.imageSize >> 24 & 0xFF), (byte)(this.xResolution & 0xFF), (byte)(this.xResolution >> 8 & 0xFF), (byte)(this.xResolution >> 16 & 0xFF), (byte)(this.xResolution >> 24 & 0xFF), (byte)(this.yResolution & 0xFF), (byte)(this.yResolution >> 8 & 0xFF), (byte)(this.yResolution >> 16 & 0xFF), (byte)(this.yResolution >> 24 & 0xFF), (byte)(this.colorsUsed & 0xFF), (byte)(this.colorsUsed >> 8 & 0xFF), (byte)(this.colorsUsed >> 16 & 0xFF), (byte)(this.colorsUsed >> 24 & 0xFF), (byte)(this.colorsImportant & 0xFF), (byte)(this.colorsImportant >> 8 & 0xFF), (byte)(this.colorsImportant >> 16 & 0xFF), (byte)(this.colorsImportant >> 24 & 0xFF)};
            outputStream.write(byArray, 0, 54);
        }
    }
}

