/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.util;

import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.image.quant.NeuQuant;
import com.icafe4j.image.quant.QuantMethod;
import com.icafe4j.image.quant.WuQuant;
import com.icafe4j.image.util.InverseColorMap;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.IOUtils;
import com.icafe4j.io.PeekHeadInputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.util.IntHashtable;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMGUtils {
    private static byte[] BM = new byte[]{66, 77};
    private static byte[] GIF = new byte[]{71, 73, 70, 56};
    private static byte[] PNG = new byte[]{-119, 80, 78, 71};
    private static byte[] TIFF_II = new byte[]{73, 73, 42, 0};
    private static byte[] TIFF_MM = new byte[]{77, 77, 0, 42};
    private static byte[] JPG = new byte[]{-1, -40, -1};
    private static byte[] PCX = new byte[]{10};
    private static byte[] JPG2000 = new byte[]{0, 0, 0, 12};
    private static float GAMMA = 0.45455f;
    private static float DISPLAY_EXPONENT = 1.8f;
    private static final Logger LOGGER = LoggerFactory.getLogger(IMGUtils.class);

    public static int[] checkColorDepth(int[] nArray, byte[] byArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray3 = new int[2];
        IntHashtable<Integer> intHashtable = new IntHashtable<Integer>(1023);
        for (int i = 0; i < nArray.length; ++i) {
            Integer n6;
            n2 = nArray[i] & 0xFFFFFF;
            if (nArray[i] >>> 24 == 0) {
                if (n4 < 0) {
                    n4 = n;
                    n5 = n2;
                }
                n2 = Integer.MAX_VALUE;
            }
            if ((n6 = (Integer)intHashtable.get(n2)) != null) {
                byArray[i] = n6.byteValue();
                continue;
            }
            if (n > 255) {
                nArray3[0] = 24;
                return nArray3;
            }
            intHashtable.put(n2, n);
            byArray[i] = (byte)n;
            nArray2[n++] = 0xFF000000 | n2;
        }
        if (n4 >= 0) {
            nArray2[n4] = n5;
        }
        while (1 << n3 < n) {
            ++n3;
        }
        nArray3[0] = n3;
        nArray3[1] = n4;
        return nArray3;
    }

    public static byte[] createGammaTable(float f, float f2) {
        int n = 256;
        byte[] byArray = new byte[n];
        double d = 1.0 / ((double)f * (double)f2);
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(Math.pow((double)i / (double)(n - 1), d) * (double)(n - 1));
        }
        return byArray;
    }

    public static void correctGamma(int[] nArray, byte[] byArray) {
        for (int i = 0; i < nArray.length; ++i) {
            byte by = byArray[(nArray[i] & 0xFF0000) >> 16];
            byte by2 = byArray[(nArray[i] & 0xFF00) >> 8];
            byte by3 = byArray[nArray[i] & 0xFF];
            nArray[i] = nArray[i] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        }
    }

    public static BufferedImage createThumbnail(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = null;
        if (inputStream instanceof RandomAccessInputStream) {
            RandomAccessInputStream randomAccessInputStream = (RandomAccessInputStream)inputStream;
            long l = randomAccessInputStream.getStreamPointer();
            randomAccessInputStream.seek(l);
            bufferedImage = javax.imageio.ImageIO.read(randomAccessInputStream);
            if (bufferedImage == null) {
                randomAccessInputStream.seek(l);
                try {
                    bufferedImage = ImageIO.read(randomAccessInputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            randomAccessInputStream.seek(l);
        } else {
            bufferedImage = javax.imageio.ImageIO.read(inputStream);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 160;
        int n4 = 120;
        if (n < n2) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n < n3) {
            n3 = n;
        }
        if (n2 < n4) {
            n4 = n2;
        }
        return IMGUtils.getScaledInstance(bufferedImage, n3, n4, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public static _8BIM createThumbnail8BIM(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriter imageWriter = ImageIO.getWriter(ImageType.JPG);
        try {
            imageWriter.write(bufferedImage, byteArrayOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        IOUtils.writeIntMM(byteArrayOutputStream, 1);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        IOUtils.writeIntMM(byteArrayOutputStream, n);
        IOUtils.writeIntMM(byteArrayOutputStream, n2);
        int n3 = 24;
        int n4 = 1;
        int n5 = (n * n3 + 31) / 32 * 4;
        IOUtils.writeIntMM(byteArrayOutputStream, n5);
        IOUtils.writeIntMM(byteArrayOutputStream, n5 * n2 * n4);
        IOUtils.writeIntMM(byteArrayOutputStream, byArray.length);
        IOUtils.writeShortMM(byteArrayOutputStream, n3);
        IOUtils.writeShortMM(byteArrayOutputStream, n4);
        byteArrayOutputStream.write(byArray);
        _8BIM _8BIM2 = new _8BIM(ImageResourceID.THUMBNAIL_RESOURCE_PS5, "thumbnail", byteArrayOutputStream.toByteArray());
        return _8BIM2;
    }

    public static void dither_Bayer(byte[] byArray, byte[] byArray2, int n, int n2, int[][] nArray) {
        int n3;
        int n4;
        int n5 = nArray.length;
        int n6 = n5 * n5 + 1;
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                nArray[n4][n3] = (nArray[n4][n3] << 8) / n6;
            }
        }
        n3 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i = 0; i < n; ++i) {
                int n7;
                byArray[n3] = byArray2[n3] == 0 ? (byte)0 : ((n7 = byArray[n3] & 0xFF) <= nArray[n4 % n5][i % n5] ? (byte)1 : 0);
                ++n3;
            }
        }
    }

    public static void dither_FloydSteinberg(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int[] nArray = new int[n + 2];
        int[] nArray2 = new int[n + 2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (byArray2[n4] == 0) {
                    byArray[n4] = 0;
                } else {
                    int n5 = (byArray[n4] & 0xFF) + nArray[j + 1];
                    if (n5 > 255) {
                        n5 = 255;
                    } else if (n5 < 0) {
                        n5 = 0;
                    }
                    int n6 = 0;
                    if (n5 <= n3) {
                        byArray[n4] = 1;
                        n6 = 0;
                    } else {
                        byArray[n4] = 0;
                        n6 = 255;
                    }
                    int n7 = n5 - n6;
                    int n8 = j + 2;
                    nArray[n8] = nArray[n8] + n7 * 7 / 16;
                    int n9 = j;
                    nArray2[n9] = nArray2[n9] + n7 * 3 / 16;
                    int n10 = j + 1;
                    nArray2[n10] = nArray2[n10] + n7 * 5 / 16;
                    int n11 = j + 2;
                    nArray2[n11] = nArray2[n11] + n7 / 16;
                }
                ++n4;
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            Arrays.fill(nArray2, 0);
        }
    }

    public static void dither_Bayer(int[] nArray, int n, int n2, byte[] byArray, int n3, int[] nArray2, int n4, int[][] nArray3) {
        int n5 = 0;
        InverseColorMap inverseColorMap = new InverseColorMap();
        inverseColorMap.createInverseMap(n3, nArray2);
        int n6 = nArray3.length;
        int n7 = nArray3.length * nArray3.length + 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray[n5] >>> 24 < 128) {
                    byArray[n5] = (byte)n4;
                } else {
                    int n8 = (nArray[n5] & 0xFF0000) >>> 16;
                    if ((n8 += n8 * nArray3[i % n6][j % n6] / n7) > 255) {
                        n8 = 255;
                    } else if (n8 < 0) {
                        n8 = 0;
                    }
                    int n9 = (nArray[n5] & 0xFF00) >>> 8;
                    n9 += n9 * nArray3[i % n6][j % n6] / n7;
                    if (n9 > 255) {
                        n9 = 255;
                    } else if (n9 < 0) {
                        n9 = 0;
                    }
                    int n10 = nArray[n5] & 0xFF;
                    n10 += n10 * nArray3[i % n6][j % n6] / n7;
                    if (n10 > 255) {
                        n10 = 255;
                    } else if (n10 < 0) {
                        n10 = 0;
                    }
                    byArray[n5] = (byte)inverseColorMap.getNearestColorIndex(n8, n9, n10);
                }
                ++n5;
            }
        }
        IMGUtils.correctGamma(nArray2, IMGUtils.createGammaTable(GAMMA, DISPLAY_EXPONENT));
    }

    public static void dither_FloydSteinberg(int[] nArray, int n, int n2, byte[] byArray, int n3, int[] nArray2, int n4) {
        int n5 = 0;
        int n6 = 0;
        int[] nArray3 = new int[n + 2];
        int[] nArray4 = new int[n + 2];
        int[] nArray5 = new int[n + 2];
        int[] nArray6 = new int[n + 2];
        int[] nArray7 = new int[n + 2];
        int[] nArray8 = new int[n + 2];
        InverseColorMap inverseColorMap = new InverseColorMap();
        inverseColorMap.createInverseMap(n3, nArray2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray[n6] >>> 24 < 128) {
                    byArray[n6] = (byte)n4;
                } else {
                    int n7 = ((nArray[n6] & 0xFF0000) >>> 16) + nArray3[j + 1];
                    if (n7 > 255) {
                        n7 = 255;
                    } else if (n7 < 0) {
                        n7 = 0;
                    }
                    int n8 = ((nArray[n6] & 0xFF00) >>> 8) + nArray4[j + 1];
                    if (n8 > 255) {
                        n8 = 255;
                    } else if (n8 < 0) {
                        n8 = 0;
                    }
                    int n9 = (nArray[n6] & 0xFF) + nArray5[j + 1];
                    if (n9 > 255) {
                        n9 = 255;
                    } else if (n9 < 0) {
                        n9 = 0;
                    }
                    n5 = inverseColorMap.getNearestColorIndex(n7, n8, n9);
                    byArray[n6] = (byte)n5;
                    int n10 = n7 - (nArray2[n5] >> 16 & 0xFF);
                    int n11 = n8 - (nArray2[n5] >> 8 & 0xFF);
                    int n12 = n9 - (nArray2[n5] & 0xFF);
                    int n13 = j + 2;
                    nArray3[n13] = nArray3[n13] + n10 * 7 / 16;
                    int n14 = j;
                    nArray6[n14] = nArray6[n14] + n10 * 3 / 16;
                    int n15 = j + 1;
                    nArray6[n15] = nArray6[n15] + n10 * 5 / 16;
                    int n16 = j + 2;
                    nArray6[n16] = nArray6[n16] + n10 / 16;
                    int n17 = j + 2;
                    nArray4[n17] = nArray4[n17] + n11 * 7 / 16;
                    int n18 = j;
                    nArray7[n18] = nArray7[n18] + n11 * 3 / 16;
                    int n19 = j + 1;
                    nArray7[n19] = nArray7[n19] + n11 * 5 / 16;
                    int n20 = j + 2;
                    nArray7[n20] = nArray7[n20] + n11 / 16;
                    int n21 = j + 2;
                    nArray5[n21] = nArray5[n21] + n12 * 7 / 16;
                    int n22 = j;
                    nArray8[n22] = nArray8[n22] + n12 * 3 / 16;
                    int n23 = j + 1;
                    nArray8[n23] = nArray8[n23] + n12 * 5 / 16;
                    int n24 = j + 2;
                    nArray8[n24] = nArray8[n24] + n12 / 16;
                }
                ++n6;
            }
            int[] nArray9 = nArray3;
            nArray3 = nArray6;
            nArray6 = nArray9;
            nArray9 = nArray4;
            nArray4 = nArray7;
            nArray7 = nArray9;
            nArray9 = nArray5;
            nArray5 = nArray8;
            nArray8 = nArray9;
            Arrays.fill(nArray6, 0);
            Arrays.fill(nArray7, 0);
            Arrays.fill(nArray8, 0);
        }
    }

    public static byte[] easyRGB2CMYK(int[] nArray, boolean bl) {
        byte[] byArray = bl ? new byte[nArray.length * 5] : new byte[nArray.length * 4];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] >> 16 & 0xFF;
            int n3 = nArray[i] >> 8 & 0xFF;
            int n4 = nArray[i] & 0xFF;
            float f = 1.0f - (float)n2 / 255.0f;
            float f2 = 1.0f - (float)n3 / 255.0f;
            float f3 = 1.0f - (float)n4 / 255.0f;
            float f4 = 1.0f;
            if (f < f4) {
                f4 = f;
            }
            if (f2 < f4) {
                f4 = f2;
            }
            if (f3 < f4) {
                f4 = f3;
            }
            if (f4 == 1.0f) {
                int n5 = n++;
                int n6 = n++;
                byArray[n++] = 0;
                byArray[n6] = 0;
                byArray[n5] = 0;
            } else {
                byArray[n++] = (byte)((f - f4) / (1.0f - f4) * 255.0f);
                byArray[n++] = (byte)((f2 - f4) / (1.0f - f4) * 255.0f);
                byArray[n++] = (byte)((f3 - f4) / (1.0f - f4) * 255.0f);
            }
            byArray[n++] = (byte)(f4 * 255.0f);
            if (!bl) continue;
            byArray[n++] = (byte)(nArray[i] >> 24 & 0xFF);
        }
        return byArray;
    }

    public static BufferedImage filterImage(BufferedImageOp bufferedImageOp, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return bufferedImageOp.filter(bufferedImage, bufferedImage2);
    }

    public static int getBitDepth(byte[] byArray, boolean bl) {
        int n;
        int n2;
        int[] nArray = new int[256];
        if (bl) {
            for (n2 = (byArray.length << 1) - 2; n2 >= 0; n2 -= 2) {
                int n3 = byArray[n2] & 0xFF;
                nArray[n3] = nArray[n3] + 1;
            }
        } else {
            for (n2 = byArray.length - 1; n2 >= 0; --n2) {
                int n4 = byArray[n2] & 0xFF;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            ++n2;
        }
        n = 0;
        while (1 << n < n2) {
            ++n;
        }
        return n;
    }

    public static ICC_ColorSpace getICCColorSpace(String string) throws IOException {
        return new ICC_ColorSpace(ICC_Profile.getInstance(IMGUtils.class.getResourceAsStream(string)));
    }

    public static ICC_Profile getICCProfile(String string) throws IOException {
        ICC_ColorSpace iCC_ColorSpace = IMGUtils.getICCColorSpace(string);
        if (iCC_ColorSpace != null) {
            return iCC_ColorSpace.getProfile();
        }
        return null;
    }

    public static int[] getRGB(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = writableRaster.getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        int n2 = writableRaster.getTransferType();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n3 * n4;
        int[] nArray = new int[n5];
        switch (n2) {
            case 3: {
                nArray = (int[])object;
                if (n == 3) {
                    for (int i = 0; i < n5; ++i) {
                        float f = 255.0f / (float)(nArray[i] >> 24 & 0xFF);
                        byte by = (byte)((float)(nArray[i] >> 16 & 0xFF) * f);
                        byte by2 = (byte)((float)(nArray[i] >> 8 & 0xFF) * f);
                        byte by3 = (byte)((float)(nArray[i] & 0xFF) * f);
                        nArray[i] = nArray[i] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
                    }
                } else if (n == 4) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n6 = nArray[i] >> 16 & 0xFF;
                        int n7 = nArray[i] >> 8 & 0xFF;
                        int n8 = nArray[i] & 0xFF;
                        nArray[i] = 0xFF000000 | n8 << 16 | n7 << 8 | n6;
                    }
                } else if (n == 1) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = 0xFF000000 | nArray[i];
                    }
                } else if (n != 2) {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
            case 0: {
                byte[] byArray = (byte[])object;
                if (n == 13 || n == 12) {
                    int n9;
                    IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
                    int n10 = indexColorModel.getMapSize();
                    byte[] byArray2 = new byte[n10];
                    byte[] byArray3 = new byte[n10];
                    byte[] byArray4 = new byte[n10];
                    byte[] byArray5 = new byte[n10];
                    int[] nArray2 = new int[n10];
                    indexColorModel.getReds(byArray2);
                    indexColorModel.getGreens(byArray3);
                    indexColorModel.getBlues(byArray4);
                    indexColorModel.getAlphas(byArray5);
                    for (n9 = 0; n9 < n10; ++n9) {
                        nArray2[n9] = (byArray5[n9] & 0xFF) << 24 | (byArray2[n9] & 0xFF) << 16 | (byArray3[n9] & 0xFF) << 8 | byArray4[n9] & 0xFF;
                    }
                    for (n9 = 0; n9 < n5; ++n9) {
                        nArray[n9] = nArray2[byArray[n9] & 0xFF];
                    }
                } else if (n == 6) {
                    int n11 = 0;
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = (byArray[n11++] & 0xFF) << 16 | (byArray[n11++] & 0xFF) << 8 | byArray[n11++] & 0xFF | (byArray[n11++] & 0xFF) << 24;
                    }
                } else if (n == 5) {
                    int n12 = 0;
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = 0xFF000000 | (byArray[n12++] & 0xFF) << 16 | (byArray[n12++] & 0xFF) << 8 | byArray[n12++] & 0xFF;
                    }
                } else if (n == 7) {
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < n5) {
                        float f = 255.0f * (float)(byArray[n14 + 3] & 0xFF);
                        byte by = (byte)((float)(byArray[n14 + 2] & 0xFF) * f);
                        byte by4 = (byte)((float)(byArray[n14 + 1] & 0xFF) * f);
                        byte by5 = (byte)((float)(byArray[n14] & 0xFF) * f);
                        nArray[n13] = byArray[n14 + 3] & 0xFF000000 | (by5 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by & 0xFF;
                        ++n13;
                        n14 += 4;
                    }
                } else if (n == 10) {
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray[i] & 0xFF) << 8 | byArray[i] & 0xFF;
                    }
                } else {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
            case 1: {
                short[] sArray = (short[])object;
                if (n == 11) {
                    for (int i = 0; i < n5; ++i) {
                        int n15 = sArray[i] >> 8 & 0xFF;
                        nArray[i] = 0xFF000000 | n15 << 16 | n15 << 8 | n15;
                    }
                } else if (n == 8) {
                    for (int i = 0; i < n5; ++i) {
                        int n16 = sArray[i] >> 11 & 0x1F;
                        int n17 = sArray[i] >> 5 & 0x3F;
                        int n18 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n16 << 19 | n17 << 10 | n18 << 3;
                    }
                } else if (n == 9) {
                    for (int i = 0; i < n5; ++i) {
                        int n19 = sArray[i] >>> 10 & 0x1F;
                        int n20 = sArray[i] >>> 5 & 0x1F;
                        int n21 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n19 << 19 | n20 << 11 | n21 << 3;
                    }
                } else {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
        }
        return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getRGB2(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n2 = dataBuffer.getNumBanks();
        int n3 = dataBuffer.getDataType();
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = n4 * n5;
        int[] nArray = new int[n6];
        switch (n3) {
            case 3: {
                nArray = ((DataBufferInt)dataBuffer).getData(0);
                if (n == 3) {
                    for (int i = 0; i < n6; ++i) {
                        float f = 255.0f / (float)(nArray[i] >> 24 & 0xFF);
                        byte by = (byte)((float)(nArray[i] >> 16 & 0xFF) * f);
                        byte by2 = (byte)((float)(nArray[i] >> 8 & 0xFF) * f);
                        byte by3 = (byte)((float)(nArray[i] & 0xFF) * f);
                        nArray[i] = nArray[i] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
                    }
                    return nArray;
                } else if (n == 4) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n7 = nArray[i] >> 16 & 0xFF;
                        int n8 = nArray[i] >> 8 & 0xFF;
                        int n9 = nArray[i] & 0xFF;
                        nArray[i] = 0xFF000000 | n9 << 16 | n8 << 8 | n7;
                    }
                    return nArray;
                } else if (n == 1) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = 0xFF000000 | nArray[i];
                    }
                    return nArray;
                } else if (n != 2) return nArray;
                return nArray;
            }
            case 0: {
                byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
                if (n == 13 || n == 12) {
                    int n10;
                    IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
                    int n11 = indexColorModel.getMapSize();
                    byte[] byArray2 = new byte[n11];
                    byte[] byArray3 = new byte[n11];
                    byte[] byArray4 = new byte[n11];
                    byte[] byArray5 = new byte[n11];
                    int[] nArray2 = new int[n11];
                    indexColorModel.getReds(byArray2);
                    indexColorModel.getGreens(byArray3);
                    indexColorModel.getBlues(byArray4);
                    indexColorModel.getAlphas(byArray5);
                    for (n10 = 0; n10 < n11; ++n10) {
                        nArray2[n10] = (byArray5[n10] & 0xFF) << 24 | (byArray2[n10] & 0xFF) << 16 | (byArray3[n10] & 0xFF) << 8 | byArray4[n10] & 0xFF;
                    }
                    n10 = writableRaster.getSampleModel().getSampleSize(0);
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    switch (n10) {
                        case 8: {
                            int n15;
                            for (n15 = 0; n15 < n6; ++n15) {
                                nArray[n15] = nArray2[byArray[0][n15] & 0xFF];
                            }
                            return nArray;
                        }
                        case 4: {
                            int n15;
                            n13 = n4 % 2;
                            n14 = n4 - n13;
                            for (int i = 0; i < n5; ++i) {
                                int n16 = 0;
                                while (n16 < n14) {
                                    nArray[n12++] = nArray2[byArray[0][n15] >>> 4 & 0xF];
                                    nArray[n12++] = nArray2[byArray[0][n15] & 0xF];
                                    n16 += 2;
                                    ++n15;
                                }
                                if (n13 == 0) continue;
                                nArray[n12++] = nArray2[byArray[0][n15] >>> 4 & 0xF];
                            }
                            return nArray;
                        }
                        case 2: {
                            int n15;
                            n13 = n4 % 4;
                            n14 = n4 - n13;
                            for (int i = 0; i < n5; ++i) {
                                int n17;
                                int n18 = 0;
                                while (n18 < n14) {
                                    n17 = 6;
                                    while (n17 >= 0) {
                                        nArray[n12] = nArray2[byArray[0][n15] >>> n17 & 3];
                                        n17 -= 2;
                                        ++n12;
                                    }
                                    n18 += 4;
                                    ++n15;
                                }
                                if (n13 == 0) continue;
                                n18 = 0;
                                n17 = 6;
                                while (n18 < n13) {
                                    nArray[n12] = nArray2[byArray[0][n15] >>> n17 & 3];
                                    ++n18;
                                    n17 -= 2;
                                    ++n12;
                                }
                                ++n15;
                            }
                            return nArray;
                        }
                        case 1: {
                            int n15;
                            n13 = n4 % 8;
                            n14 = n4 - n13;
                            int n19 = 8 - n13;
                            for (int i = 0; i < n5; ++i) {
                                int n20 = 0;
                                while (n20 < n14) {
                                    int n21 = 7;
                                    while (n21 >= 0) {
                                        nArray[n12] = nArray2[byArray[0][n15] >>> n21 & 1];
                                        --n21;
                                        ++n12;
                                    }
                                    n20 += 8;
                                    ++n15;
                                }
                                if (n13 == 0) continue;
                                n20 = 7;
                                while (n20 >= n19) {
                                    nArray[n12] = nArray2[byArray[0][n15] >>> n20 & 1];
                                    --n20;
                                    ++n12;
                                }
                                ++n15;
                            }
                            return nArray;
                        }
                        default: {
                            LOGGER.error(n10 + " bit color depth is not valid for indexed image...");
                        }
                    }
                    return nArray;
                }
                if (n == 6) {
                    if (n2 == 1) {
                        int n22 = 0;
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = (byArray[0][n22++] & 0xFF) << 24 | byArray[0][n22++] & 0xFF | (byArray[0][n22++] & 0xFF) << 8 | (byArray[0][n22++] & 0xFF) << 16;
                        }
                        return nArray;
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = (byArray[0][i] & 0xFF) << 24 | byArray[1][i] & 0xFF | (byArray[2][i] & 0xFF) << 8 | (byArray[3][i] & 0xFF) << 16;
                        }
                    }
                    return nArray;
                } else if (n == 5) {
                    if (n2 == 1) {
                        int n23 = 0;
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = 0xFF000000 | byArray[0][n23++] & 0xFF | (byArray[0][n23++] & 0xFF) << 8 | (byArray[0][n23++] & 0xFF) << 16;
                        }
                        return nArray;
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = 0xFF000000 | byArray[0][i] & 0xFF | (byArray[1][i] & 0xFF) << 8 | (byArray[2][i] & 0xFF) << 16;
                        }
                    }
                    return nArray;
                } else if (n == 7) {
                    if (n2 == 1) {
                        int n24 = 0;
                        int n25 = 0;
                        while (n24 < n6) {
                            float f = 255.0f * (float)(byArray[0][n25] & 0xFF);
                            byte by = (byte)((float)(byArray[0][n25 + 1] & 0xFF) * f);
                            byte by4 = (byte)((float)(byArray[0][n25 + 2] & 0xFF) * f);
                            byte by5 = (byte)((float)(byArray[0][n25 + 3] & 0xFF) * f);
                            nArray[n24] = (byArray[0][n25] & 0xFF) << 24 | (by5 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by & 0xFF;
                            ++n24;
                            n25 += 4;
                        }
                        return nArray;
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            float f = 255.0f * (float)(byArray[0][i] & 0xFF);
                            byte by = (byte)((float)(byArray[1][i] & 0xFF) * f);
                            byte by6 = (byte)((float)(byArray[2][i] & 0xFF) * f);
                            byte by7 = (byte)((float)(byArray[3][i] & 0xFF) * f);
                            nArray[i] = (byArray[0][i] & 0xFF) << 24 | (by7 & 0xFF) << 16 | (by6 & 0xFF) << 8 | by & 0xFF;
                        }
                    }
                    return nArray;
                } else {
                    if (n != 10) return nArray;
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = 0xFF000000 | (byArray[0][i] & 0xFF) << 16 | (byArray[0][i] & 0xFF) << 8 | byArray[0][i] & 0xFF;
                    }
                }
                return nArray;
            }
            case 1: {
                short[] sArray = ((DataBufferUShort)dataBuffer).getBankData()[0];
                if (n == 11) {
                    for (int i = 0; i < n6; ++i) {
                        int n26 = sArray[i] >> 8 & 0xFF;
                        nArray[i] = 0xFF000000 | n26 << 16 | n26 << 8 | n26;
                    }
                    return nArray;
                } else if (n == 8) {
                    for (int i = 0; i < n6; ++i) {
                        int n27 = sArray[i] >> 11 & 0x1F;
                        int n28 = sArray[i] >> 5 & 0x3F;
                        int n29 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n27 << 19 | n28 << 10 | n29 << 3;
                    }
                    return nArray;
                } else {
                    if (n != 9) return nArray;
                    for (int i = 0; i < n6; ++i) {
                        int n30 = sArray[i] >>> 10 & 0x1F;
                        int n31 = sArray[i] >>> 5 & 0x1F;
                        int n32 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n30 << 19 | n31 << 11 | n32 << 3;
                    }
                }
                return nArray;
            }
        }
        return bufferedImage.getRGB(0, 0, n4, n5, nArray, 0, n4);
    }

    public static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        if (n4 < n || n5 < n2 || !bl) {
            return IMGUtils.scaleImage(bufferedImage2, n3, object, n, n2);
        }
        do {
            if (n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (n5 > n2 && (n5 /= 2) < n2) {
                n5 = n2;
            }
            bufferedImage2 = IMGUtils.scaleImage(bufferedImage2, n3, object, n4, n5);
        } while (n4 != n || n5 != n2);
        return bufferedImage2;
    }

    public static ImageType guessImageType(byte[] byArray) {
        ImageType imageType = ImageType.UNKNOWN;
        if (Arrays.equals(byArray, TIFF_II) || Arrays.equals(byArray, TIFF_MM)) {
            imageType = ImageType.TIFF;
        } else if (Arrays.equals(byArray, PNG)) {
            imageType = ImageType.PNG;
        } else if (Arrays.equals(byArray, GIF)) {
            imageType = ImageType.GIF;
        } else if (byArray[0] == JPG[0] && byArray[1] == JPG[1] && byArray[2] == JPG[2]) {
            imageType = ImageType.JPG;
        } else if (byArray[0] == BM[0] && byArray[1] == BM[1]) {
            imageType = ImageType.BMP;
        } else if (byArray[0] == PCX[0]) {
            imageType = ImageType.PCX;
        } else if (Arrays.equals(byArray, JPG2000)) {
            imageType = ImageType.JPG2000;
        } else if (byArray[1] == 0 || byArray[1] == 1) {
            switch (byArray[2]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 32: 
                case 33: {
                    imageType = ImageType.TGA;
                }
            }
        } else {
            LOGGER.error("Unknown image type format!");
        }
        return imageType;
    }

    public static ImageType guessImageType(PeekHeadInputStream peekHeadInputStream) throws IOException {
        byte[] byArray = peekHeadInputStream.peek(4);
        ImageType imageType = IMGUtils.guessImageType(byArray);
        return imageType;
    }

    public static ImageType guessImageType(RandomAccessInputStream randomAccessInputStream) throws IOException {
        byte[] byArray = new byte[4];
        long l = randomAccessInputStream.getStreamPointer();
        randomAccessInputStream.read(byArray);
        ImageType imageType = IMGUtils.guessImageType(byArray);
        randomAccessInputStream.seek(l);
        return imageType;
    }

    public static WritableRaster iccp2rgbRaster(WritableRaster writableRaster, ColorModel colorModel) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorModel.getColorSpace(), colorSpace, null);
        WritableRaster writableRaster2 = null;
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        writableRaster2 = colorConvertOp.filter(bufferedImage, null).getRaster();
        return writableRaster2;
    }

    public static void invertBits(byte[] byArray, int n) {
        for (int i = byArray.length - 1; i >= 0; i -= n) {
            byArray[i] = ~byArray[i];
        }
    }

    public static void invertBits(short[] sArray, int n) {
        for (int i = sArray.length - 1; i >= 0; i -= n) {
            sArray[i] = ~sArray[i];
        }
    }

    private static int[] reduceColorsPopularity(int[] nArray, int n, byte[] byArray, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n > 8 || n < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n);
        }
        int n10 = 1 << n;
        int[] nArray3 = new int[65536];
        int[] nArray4 = new int[65536];
        int[] nArray5 = new int[n10];
        int[] nArray6 = new int[n10];
        int[] nArray7 = new int[n10];
        int[] nArray8 = new int[n10];
        int[] nArray9 = new int[2];
        int n11 = 1;
        int n12 = -1;
        int n13 = -1;
        for (n9 = 0; n9 < nArray.length; ++n9) {
            int n14 = bl ? (nArray[n9] >>> 24 == 0 ? 1 : 0) : (n8 = nArray[n9] >>> 24 < 128 ? 1 : 0);
            if (n8 != 0 && n12 < 0) {
                n12 = nArray[n9];
            }
            n7 = (nArray[n9] & 0xF00000) >>> 20;
            n6 = (nArray[n9] & 0xF000) >>> 8;
            n5 = (nArray[n9] & 0xF0) << 4;
            n4 = (nArray[n9] & 0xF0000000) >>> 16;
            int n15 = n3 = n4 | n7 | n6 | n5;
            nArray3[n15] = nArray3[n15] + 1;
        }
        int n16 = 0;
        for (n9 = 0; n9 < 65536; ++n9) {
            if (nArray3[n9] == 0 || (n9 & 0xF000) == 0) continue;
            nArray3[n16] = nArray3[n9];
            nArray4[n16++] = n9;
        }
        n9 = 1;
        while (n9 < n16) {
            n9 = 3 * n9 + 1;
        }
        while (n9 > 0) {
            for (n8 = n9; n8 < n16; ++n8) {
                int n17 = nArray3[n8];
                int n18 = nArray4[n8];
                for (n2 = n8; n2 >= n9 && n17 >= nArray3[n2 - n9]; n2 -= n9) {
                    nArray3[n2] = nArray3[n2 - n9];
                    nArray4[n2] = nArray4[n2 - n9];
                }
                nArray3[n2] = n17;
                nArray4[n2] = n18;
            }
            n9 /= 3;
        }
        int[] nArray10 = new int[n10 >= n16 ? n10 : n16];
        for (n8 = 0; n8 < n10; ++n8) {
            nArray7[n8] = (nArray4[n8] & 0xF00) >>> 4;
            nArray6[n8] = nArray4[n8] & 0xF0;
            nArray5[n8] = (nArray4[n8] & 0xF) << 4;
            nArray8[n8] = (nArray4[n8] & 0xF000) >>> 8;
            nArray2[n8] = nArray8[n8] << 24 | nArray5[n8] << 16 | nArray6[n8] << 8 | nArray7[n8];
            nArray10[n8] = n8;
        }
        if (n12 >= 0) {
            --n10;
        }
        if (n16 > n10) {
            for (n8 = n10; n8 < n16; ++n8) {
                n3 = 0;
                n5 = (nArray4[n8] & 0xF00) >>> 4;
                n6 = nArray4[n8] & 0xF0;
                n7 = (nArray4[n8] & 0xF) << 4;
                n4 = (nArray4[n8] & 0xF000) >>> 8;
                int n19 = (n7 - nArray5[0]) * (n7 - nArray5[0]) + (n6 - nArray6[0]) * (n6 - nArray6[0]) + (n5 - nArray7[0]) * (n5 - nArray7[0]) + (n4 - nArray8[0]) * (n4 - nArray8[0]);
                for (n2 = 1; n2 < n10; ++n2) {
                    int n20 = (n7 - nArray5[n2]) * (n7 - nArray5[n2]) + (n6 - nArray6[n2]) * (n6 - nArray6[n2]) + (n5 - nArray7[n2]) * (n5 - nArray7[n2]) + (n4 - nArray8[n2]) * (n4 - nArray8[n2]);
                    if (n20 >= n19) continue;
                    n19 = n20;
                    n3 = n2;
                }
                nArray10[n8] = n3;
            }
        }
        for (n8 = 0; n8 < n16; ++n8) {
            nArray3[nArray4[n8]] = n8;
        }
        if (n12 >= 0) {
            ++n16;
        }
        while (1 << n11 < n16) {
            ++n11;
        }
        if (n11 > n) {
            n11 = n;
        }
        if (n12 >= 0) {
            n13 = (1 << n11) - 1;
            nArray2[n13] = n12;
        }
        for (n8 = 0; n8 < nArray.length; ++n8) {
            n7 = (nArray[n8] & 0xF00000) >>> 20;
            n6 = (nArray[n8] & 0xF000) >>> 8;
            n5 = (nArray[n8] & 0xF0) << 4;
            n4 = (nArray[n8] & 0xF0000000) >>> 16;
            n3 = n4 | n7 | n6 | n5;
            n2 = bl ? (nArray[n8] >>> 24 == 0 || (n3 & 0xF000) == 0 ? 1 : 0) : (nArray[n8] >>> 24 < 128 ? 1 : 0);
            byArray[n8] = n2 != 0 ? (byte)n13 : (byte)nArray10[nArray3[n3]];
        }
        nArray9[0] = n11;
        nArray9[1] = n13;
        return nArray9;
    }

    public static int[] reduceColors(QuantMethod quantMethod, int[] nArray, int n, byte[] byArray, int[] nArray2, boolean bl) {
        int[] nArray3 = new int[2];
        if (quantMethod == QuantMethod.WU_QUANT) {
            new WuQuant(nArray, 1 << n).quantize(byArray, nArray2, nArray3);
        } else if (quantMethod == QuantMethod.NEU_QUANT) {
            new NeuQuant(nArray).quantize(byArray, nArray2, nArray3);
        } else {
            nArray3 = IMGUtils.reduceColorsPopularity(nArray, n, byArray, nArray2, bl);
        }
        return nArray3;
    }

    public static int[] reduceColorsDiffusionDither(int[] nArray, int n, int n2, int n3, byte[] byArray, int[] nArray2) {
        if (n3 > 8 || n3 < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n3);
        }
        int[] nArray3 = new int[2];
        int n4 = IMGUtils.reduceColors(nArray, n3, nArray2, nArray3);
        IMGUtils.dither_FloydSteinberg(nArray, n, n2, byArray, n4, nArray2, nArray3[1]);
        return nArray3;
    }

    public static int[] reduceColorsDiffusionDither(QuantMethod quantMethod, int[] nArray, int n, int n2, int n3, byte[] byArray, int[] nArray2) {
        if (n3 > 8 || n3 < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n3);
        }
        int[] nArray3 = new int[2];
        int n4 = 0;
        n4 = quantMethod == QuantMethod.WU_QUANT ? new WuQuant(nArray, 1 << n3).quantize(nArray2, nArray3) : (quantMethod == QuantMethod.NEU_QUANT ? new NeuQuant(nArray).quantize(nArray2, nArray3) : IMGUtils.reduceColors(nArray, n3, nArray2, nArray3));
        IMGUtils.dither_FloydSteinberg(nArray, n, n2, byArray, n4, nArray2, nArray3[1]);
        return nArray3;
    }

    public static int[] reduceColorsOrderedDither(int[] nArray, int n, int n2, int n3, byte[] byArray, int[] nArray2, int[][] nArray3) {
        if (n3 > 8 || n3 < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n3);
        }
        int[] nArray4 = new int[2];
        int n4 = IMGUtils.reduceColors(nArray, n3, nArray2, nArray4);
        IMGUtils.dither_Bayer(nArray, n, n2, byArray, n4, nArray2, nArray4[1], nArray3);
        return nArray4;
    }

    public static int[] reduceColorsOrderedDither(QuantMethod quantMethod, int[] nArray, int n, int n2, int n3, byte[] byArray, int[] nArray2, int[][] nArray3) {
        if (n3 > 8 || n3 < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n3);
        }
        int[] nArray4 = new int[2];
        int n4 = 0;
        n4 = quantMethod == QuantMethod.WU_QUANT ? new WuQuant(nArray, 1 << n3).quantize(nArray2, nArray4) : (quantMethod == QuantMethod.NEU_QUANT ? new NeuQuant(nArray).quantize(nArray2, nArray4) : IMGUtils.reduceColors(nArray, n3, nArray2, nArray4));
        IMGUtils.dither_Bayer(nArray, n, n2, byArray, n4, nArray2, nArray4[1], nArray3);
        return nArray4;
    }

    private static int reduceColors(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (n > 8 || n < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n);
        }
        int n7 = 1 << n;
        int[] nArray4 = new int[4096];
        int[] nArray5 = new int[4096];
        int n8 = 1;
        int n9 = -1;
        int n10 = -1;
        for (n6 = 0; n6 < nArray.length; ++n6) {
            int n11;
            if (nArray[n6] >>> 24 < 128 && n9 < 0) {
                n9 = nArray[n6];
            }
            n5 = (nArray[n6] & 0xF00000) >>> 20;
            n4 = (nArray[n6] & 0xF000) >>> 8;
            n3 = (nArray[n6] & 0xF0) << 4;
            int n12 = n11 = n5 | n4 | n3;
            nArray4[n12] = nArray4[n12] + 1;
        }
        int n13 = 0;
        for (n6 = 0; n6 < 4096; ++n6) {
            if (nArray4[n6] == 0) continue;
            nArray4[n13] = nArray4[n6];
            nArray5[n13++] = n6;
        }
        n6 = 1;
        while (n6 < n13) {
            n6 = 3 * n6 + 1;
        }
        while (n6 > 0) {
            for (n2 = n6; n2 < n13; ++n2) {
                int n14 = nArray4[n2];
                int n15 = nArray5[n2];
                for (int i = n2; i >= n6 && n14 >= nArray4[i - n6]; i -= n6) {
                    nArray4[i] = nArray4[i - n6];
                    nArray5[i] = nArray5[i - n6];
                }
                nArray4[i] = n14;
                nArray5[i] = n15;
            }
            n6 /= 3;
        }
        int[] nArray6 = new int[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            n3 = (nArray5[n2] & 0xF00) >>> 4;
            n4 = nArray5[n2] & 0xF0;
            n5 = (nArray5[n2] & 0xF) << 4;
            nArray2[n2] = 0xFF000000 | n5 << 16 | n4 << 8 | n3;
            nArray6[n2] = n2;
        }
        if (n9 >= 0) {
            --n7;
            ++n13;
        }
        while (1 << n8 < n13) {
            ++n8;
        }
        if (n8 > n) {
            n8 = n;
        }
        if (n9 >= 0) {
            n10 = (1 << n8) - 1;
            nArray2[n10] = n9;
            --n13;
        }
        nArray3[0] = n8;
        nArray3[1] = n10;
        return n13 < n7 ? n13 : n7;
    }

    public static byte[] rgb2bilevel(int[] nArray) {
        int n;
        byte[] byArray = new byte[nArray.length];
        long l = 0L;
        for (n = 0; n < nArray.length; ++n) {
            byArray[n] = nArray[n] >>> 24 < 128 ? -1 : (byte)((double)(nArray[n] >> 16 & 0xFF) * 0.2126 + (double)(nArray[n] >> 8 & 0xFF) * 0.7152 + (double)(nArray[n] & 0xFF) * 0.0722);
            l += (long)(byArray[n] & 0xFF);
        }
        n = (int)(l / (long)byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byArray[i] & 0xFF) <= n ? (byte)1 : 0;
        }
        return byArray;
    }

    public static byte[] rgb2bilevelOrderedDither(int[] nArray, int n, int n2, int[][] nArray2) {
        byte[] byArray = new byte[nArray.length];
        byte[] byArray2 = new byte[nArray.length];
        Arrays.fill(byArray2, (byte)1);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >>> 24 < 128) {
                byArray[i] = -1;
                byArray2[i] = 0;
                continue;
            }
            byArray[i] = (byte)((double)(nArray[i] >> 16 & 0xFF) * 0.2126 + (double)(nArray[i] >> 8 & 0xFF) * 0.7152 + (double)(nArray[i] & 0xFF) * 0.0722);
        }
        IMGUtils.dither_Bayer(byArray, byArray2, n, n2, nArray2);
        return byArray;
    }

    public static byte[] rgb2bilevelDiffusionDither(int[] nArray, int n, int n2) {
        int n3;
        byte[] byArray = new byte[nArray.length];
        byte[] byArray2 = new byte[nArray.length];
        long l = 0L;
        Arrays.fill(byArray2, (byte)1);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] >>> 24 < 128) {
                byArray[n3] = -1;
                byArray2[n3] = 0;
            } else {
                byArray[n3] = (byte)((double)(nArray[n3] >> 16 & 0xFF) * 0.2126 + (double)(nArray[n3] >> 8 & 0xFF) * 0.7152 + (double)(nArray[n3] & 0xFF) * 0.0722);
            }
            l += (long)(byArray[n3] & 0xFF);
        }
        n3 = (int)(l / (long)byArray.length);
        IMGUtils.dither_FloydSteinberg(byArray, byArray2, n, n2, n3);
        return byArray;
    }

    public static void RGB2CMYK(ICC_ColorSpace iCC_ColorSpace, int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, float[][] fArray4, int n, int n2) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, iCC_ColorSpace, null);
        BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), writableRaster, false, null);
        BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        byte[] byArray = (byte[])writableRaster2.getDataElements(0, 0, n, n2, null);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = (float)(byArray[n3++] & 0xFF) - 128.0f;
                fArray2[i][j] = (float)(byArray[n3++] & 0xFF) - 128.0f;
                fArray3[i][j] = (float)(byArray[n3++] & 0xFF) - 128.0f;
                fArray4[i][j] = (float)(byArray[n3++] & 0xFF) - 128.0f;
            }
        }
    }

    public static byte[] RGB2CMYK(ICC_ColorSpace iCC_ColorSpace, int[] nArray, int n, int n2, boolean bl) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        int[] nArray2 = new int[]{0xFF0000, 65280, 255};
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, iCC_ColorSpace, null);
        ColorModel colorModel = null;
        WritableRaster writableRaster = null;
        if (bl) {
            colorModel = ColorModel.getRGBdefault();
            nArray2 = new int[]{0xFF0000, 65280, 255, -16777216};
        } else {
            colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        WritableRaster writableRaster2 = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray2, null);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster2, false, null);
        BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
        writableRaster = bufferedImage2.getRaster();
        return (byte[])writableRaster.getDataElements(0, 0, n, n2, null);
    }

    public static void RGB2CMYK_Inverted(ICC_ColorSpace iCC_ColorSpace, int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, float[][] fArray4, int n, int n2) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, iCC_ColorSpace, null);
        BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), writableRaster, false, null);
        BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        byte[] byArray = (byte[])writableRaster2.getDataElements(0, 0, n, n2, null);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = 128.0f - (float)(byArray[n3++] & 0xFF);
                fArray2[i][j] = 128.0f - (float)(byArray[n3++] & 0xFF);
                fArray3[i][j] = 128.0f - (float)(byArray[n3++] & 0xFF);
                fArray4[i][j] = 128.0f - (float)(byArray[n3++] & 0xFF);
            }
        }
    }

    public static byte[] rgb2grayscale(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((double)(nArray[i] >> 16 & 0xFF) * 0.2126 + (double)(nArray[i] >> 8 & 0xFF) * 0.7152 + (double)(nArray[i] & 0xFF) * 0.0722);
        }
        return byArray;
    }

    public static float[][] rgb2grayscale(int[] nArray, int n, int n2) {
        float[][] fArray = new float[n2][n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                fArray[i][n4] = (float)((double)(nArray[n3] >> 16 & 0xFF) * 0.2126 + (double)(nArray[n3] >> 8 & 0xFF) * 0.7152 + (double)(nArray[n3] & 0xFF) * 0.0722 - 128.0);
                ++n4;
                ++n3;
            }
        }
        return fArray;
    }

    public static byte[] rgb2grayscaleA(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 1];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byArray[n++] = (byte)((double)(nArray[i] >> 16 & 0xFF) * 0.2126 + (double)(nArray[i] >> 8 & 0xFF) * 0.7152 + (double)(nArray[i] & 0xFF) * 0.0722);
            byArray[n++] = (byte)(nArray[i] >> 24 & 0xFF);
        }
        return byArray;
    }

    public static byte[] RGB2YCbCr(int[] nArray) {
        int n = 0;
        byte[] byArray = new byte[nArray.length * 3];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] >> 16 & 0xFF;
            int n3 = nArray[i] >> 8 & 0xFF;
            int n4 = nArray[i] & 0xFF;
            byArray[n++] = (byte)(0.299f * (float)n2 + 0.587f * (float)n3 + 0.114f * (float)n4);
            byArray[n++] = (byte)(-0.1687f * (float)n2 - 0.3313f * (float)n3 + 0.5f * (float)n4 + 128.0f);
            byArray[n++] = (byte)(0.5f * (float)n2 - 0.4187f * (float)n3 - 0.0813f * (float)n4 + 128.0f);
        }
        return byArray;
    }

    public static void RGB2YCbCr(int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[n3] >> 16 & 0xFF;
                int n5 = nArray[n3] >> 8 & 0xFF;
                int n6 = nArray[n3++] & 0xFF;
                fArray[i][j] = 0.299f * (float)n4 + 0.587f * (float)n5 + 0.114f * (float)n6 - 128.0f;
                fArray2[i][j] = -0.1687f * (float)n4 - 0.3313f * (float)n5 + 0.5f * (float)n6;
                fArray3[i][j] = 0.5f * (float)n4 - 0.4187f * (float)n5 - 0.0813f * (float)n6;
            }
        }
    }

    public static void RGB2YCbCr(int[][] nArray, int[][] nArray2, int[][] nArray3, float[][] fArray, float[][] fArray2, float[][] fArray3, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = 0.299f * (float)nArray[i][j] + 0.587f * (float)nArray2[i][j] + 0.114f * (float)nArray3[i][j] - 128.0f;
                fArray2[i][j] = -0.1687f * (float)nArray[i][j] - 0.3313f * (float)nArray2[i][j] + 0.5f * (float)nArray3[i][j];
                fArray3[i][j] = 0.5f * (float)nArray[i][j] - 0.4187f * (float)nArray2[i][j] - 0.0813f * (float)nArray3[i][j];
            }
        }
    }

    public static byte[] RGB2YCbCrA(int[] nArray) {
        int n = 0;
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] >> 24 & 0xFF;
            int n3 = nArray[i] >> 16 & 0xFF;
            int n4 = nArray[i] >> 8 & 0xFF;
            int n5 = nArray[i] & 0xFF;
            byArray[n++] = (byte)(0.299f * (float)n3 + 0.587f * (float)n4 + 0.114f * (float)n5);
            byArray[n++] = (byte)(-0.1687f * (float)n3 - 0.3313f * (float)n4 + 0.5f * (float)n5 + 128.0f);
            byArray[n++] = (byte)(0.5f * (float)n3 - 0.4187f * (float)n4 - 0.0813f * (float)n5 + 128.0f);
            byArray[n++] = (byte)n2;
        }
        return byArray;
    }

    public static void RGB2YCCK_Inverted(ICC_ColorSpace iCC_ColorSpace, int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, float[][] fArray4, int n, int n2) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, iCC_ColorSpace, null);
        BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), writableRaster, false, null);
        BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        byte[] byArray = (byte[])writableRaster2.getDataElements(0, 0, n, n2, null);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = 255.0f - (float)(byArray[n3++] & 0xFF);
                float f2 = 255.0f - (float)(byArray[n3++] & 0xFF);
                float f3 = 255.0f - (float)(byArray[n3++] & 0xFF);
                fArray[i][j] = 128.0f - (f * 0.299f + f2 * 0.587f + f3 * 0.114f);
                fArray2[i][j] = 0.16874f * f + 0.33126f * f2 - 0.5f * f3;
                fArray3[i][j] = -0.5f * f + 0.41869f * f2 + 0.08131f * f3;
                fArray4[i][j] = 128.0f - (float)(byArray[n3++] & 0xFF);
            }
        }
    }

    private static BufferedImage scaleImage(BufferedImage bufferedImage, int n, Object object, int n2, int n3) {
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private IMGUtils() {
    }
}

