/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.tiff;

import com.icafe4j.image.tiff.ASCIIField;
import com.icafe4j.image.tiff.ByteField;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.SByteField;
import com.icafe4j.image.tiff.SLongField;
import com.icafe4j.image.tiff.SRationalField;
import com.icafe4j.image.tiff.SShortField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.UndefinedField;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    BYTE("Byte", 1),
    ASCII("ASCII", 2),
    SHORT("Short", 3),
    LONG("Long", 4),
    RATIONAL("Rational", 5),
    SBYTE("SByte", 6),
    UNDEFINED("Undefined", 7),
    SSHORT("SShort", 8),
    SLONG("SLong", 9),
    SRATIONAL("SRational", 10),
    FLOAT("Float", 11),
    DOUBLE("Double", 12),
    IFD("IFD", 13),
    WINDOWSXP("WindowsXP", 14),
    UNKNOWN("Unknown", 0);

    private static final Map<Short, FieldType> typeMap;
    private final String name;
    private final short value;

    private FieldType(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    public static TiffField<?> createField(Tag tag, FieldType fieldType, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        TiffField tiffField = null;
        Class<?> clazz = object.getClass();
        switch (fieldType) {
            case ASCII: {
                if (clazz != String.class) break;
                tiffField = new ASCIIField(tag.getValue(), (String)object);
                break;
            }
            case BYTE: 
            case SBYTE: 
            case UNDEFINED: {
                byte[] byArray;
                if (clazz != byte[].class || (byArray = (byte[])object).length <= 0) break;
                if (fieldType == BYTE) {
                    tiffField = new ByteField(tag.getValue(), byArray);
                    break;
                }
                if (fieldType == SBYTE) {
                    tiffField = new SByteField(tag.getValue(), byArray);
                    break;
                }
                tiffField = new UndefinedField(tag.getValue(), byArray);
                break;
            }
            case SHORT: 
            case SSHORT: {
                short[] sArray;
                if (clazz != short[].class || (sArray = (short[])object).length <= 0) break;
                if (fieldType == SHORT) {
                    tiffField = new ShortField(tag.getValue(), sArray);
                    break;
                }
                tiffField = new SShortField(tag.getValue(), sArray);
                break;
            }
            case LONG: 
            case SLONG: {
                int[] nArray;
                if (clazz != int[].class || (nArray = (int[])object).length <= 0) break;
                if (fieldType == LONG) {
                    tiffField = new LongField(tag.getValue(), nArray);
                    break;
                }
                tiffField = new SLongField(tag.getValue(), nArray);
                break;
            }
            case RATIONAL: 
            case SRATIONAL: {
                int[] nArray;
                if (clazz != int[].class || (nArray = (int[])object).length <= 0 || nArray.length % 2 != 0) break;
                if (fieldType == RATIONAL) {
                    tiffField = new RationalField(tag.getValue(), nArray);
                    break;
                }
                tiffField = new SRationalField(tag.getValue(), nArray);
                break;
            }
            case WINDOWSXP: {
                if (clazz != String.class) break;
                try {
                    byte[] byArray = (((String)object).trim() + '\u0000').getBytes("UTF-16LE");
                    tiffField = new ByteField(tag.getValue(), byArray);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                break;
            }
        }
        return tiffField;
    }

    public String getName() {
        return this.name;
    }

    public short getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static FieldType fromShort(short s) {
        FieldType fieldType = typeMap.get(s);
        if (fieldType == null) {
            return UNKNOWN;
        }
        return fieldType;
    }

    public static boolean validateData(FieldType fieldType, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        boolean bl = false;
        Class<?> clazz = object.getClass();
        switch (fieldType) {
            case ASCII: 
            case WINDOWSXP: {
                if (clazz != String.class) break;
                bl = true;
                break;
            }
            case BYTE: 
            case SBYTE: 
            case UNDEFINED: {
                byte[] byArray;
                if (clazz != byte[].class || (byArray = (byte[])object).length <= 0) break;
                bl = true;
                break;
            }
            case SHORT: 
            case SSHORT: {
                short[] sArray;
                if (clazz != short[].class || (sArray = (short[])object).length <= 0) break;
                bl = true;
                break;
            }
            case LONG: 
            case SLONG: {
                int[] nArray;
                if (clazz != int[].class || (nArray = (int[])object).length <= 0) break;
                bl = true;
                break;
            }
            case RATIONAL: 
            case SRATIONAL: {
                int[] nArray;
                if (clazz != int[].class || (nArray = (int[])object).length <= 0 || nArray.length % 2 != 0) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static {
        typeMap = new HashMap<Short, FieldType>();
        for (FieldType fieldType : FieldType.values()) {
            typeMap.put(fieldType.getValue(), fieldType);
        }
    }
}

