/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.color.CMYKColorSpace;
import com.icafe4j.image.color.Int32ComponentColorModel;
import com.icafe4j.image.compression.UnsupportedCompressionException;
import com.icafe4j.image.compression.ccitt.G31DDecoder;
import com.icafe4j.image.compression.ccitt.G32DDecoder;
import com.icafe4j.image.compression.deflate.DeflateDecoder;
import com.icafe4j.image.compression.lzw.LZWTreeDecoder;
import com.icafe4j.image.compression.packbits.Packbits;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.tiff.ASCIIField;
import com.icafe4j.image.tiff.ByteField;
import com.icafe4j.image.tiff.DoubleField;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.FloatField;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.tiff.UndefinedField;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.IOUtils;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.ReadStrategyII;
import com.icafe4j.io.ReadStrategyMM;
import com.icafe4j.string.StringUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIFFReader
extends ImageReader {
    private RandomAccessInputStream randIS = null;
    protected List<IFD> ifds;
    private List<BufferedImage> frames;
    private int endian = 19789;
    private static final int[] redMask;
    private static final int[] greenMask;
    private static final int[] blueMask;
    private static final int[] BLACK_WHITE_PALETTE;
    private static final int[] BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
    private static final int[] FOUR_COLOR_PALETTE;
    private static final int[] FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] SIXTEEN_COLOR_PALETTE;
    private static final int[] SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] EIGHT_BIT_COLOR_PALETTE;
    private static final int[] EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
    private static int GROUP3OPT_2DENCODING;
    private static int GROUP3OPT_UNCOMPRESSED;
    private static final int bufLen = 40960;
    private static final Logger LOGGER;

    protected BufferedImage decode(IFD iFD) throws Exception {
        TiffField<?> tiffField = iFD.getField(TiffTag.TILE_WIDTH);
        TiffField<?> tiffField2 = iFD.getField(TiffTag.TILE_LENGTH);
        if (tiffField != null && tiffField2 != null) {
            return this.decodeTiledTiff(iFD);
        }
        return this.decodeStrippedTiff(iFD);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private BufferedImage decodeStrippedTiff(IFD var1_1) throws Exception {
        var2_2 = var1_1.getField(TiffTag.COMPRESSION);
        var3_3 = new short[]{1};
        if (var2_2 != null) {
            var3_3 = (short[])var2_2.getData();
        }
        var4_4 = TiffFieldEnum.Compression.fromValue(var3_3[0] & 65535);
        TIFFReader.LOGGER.info("Compression type: {}", (Object)var4_4.getDescription());
        var5_5 = var1_1.getField(TiffTag.STRIP_OFFSETS);
        var6_6 = var1_1.getField(TiffTag.STRIP_BYTE_COUNTS);
        if (var5_5 == null) {
            throw new RuntimeException("Missing required field stripOffsets");
        }
        var7_7 = var5_5.getDataAsLong();
        var8_8 = null;
        if (var6_6 != null) ** GOTO lbl18
        if (var7_7.length == 1) {
            var8_8 = new int[]{0};
        } else {
            throw new RuntimeException("Missing required field stripByteCounts");
lbl18:
            // 1 sources

            var8_8 = var6_6.getDataAsLong();
        }
        var9_9 = var1_1.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        var10_10 = var1_1.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        TIFFReader.LOGGER.info("Image width: {}", (Object)var9_9);
        TIFFReader.LOGGER.info("Image height: {}", (Object)var10_10);
        var11_11 = var1_1.getField(TiffTag.ROWS_PER_STRIP);
        var12_12 = var10_10;
        if (var11_11 != null) {
            var12_12 = var11_11.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Rows per strip: {}", (Object)var12_12);
        var13_13 = var1_1.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        var14_14 = TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue();
        if (var13_13 != null) {
            var14_14 = var13_13.getDataAsLong()[0];
        }
        var15_15 = TiffFieldEnum.PhotoMetric.fromValue(var14_14);
        TIFFReader.LOGGER.info("PhotoMetric: {}", (Object)var15_15);
        var16_16 = var1_1.getField(TiffTag.BITS_PER_SAMPLE);
        var17_17 = 1;
        if (var16_16 != null) {
            var17_17 = var16_16.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Bits per sample: {}", (Object)var17_17);
        var18_18 = var1_1.getField(TiffTag.SAMPLES_PER_PIXEL);
        var19_19 = 1;
        if (var18_18 != null) {
            var19_19 = var18_18.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Samples per pixel: {}", (Object)var19_19);
        var20_20 = var1_1.getField(TiffTag.PREDICTOR);
        var21_21 = 0;
        if (var20_20 != null) {
            var21_21 = var20_20.getDataAsLong()[0];
            TIFFReader.LOGGER.info("Predictor: {}", (Object)var21_21);
        }
        var22_22 = var1_1.getField(TiffTag.PLANAR_CONFIGURATTION);
        var23_23 = 1;
        if (var22_22 != null) {
            var23_23 = var22_22.getDataAsLong()[0];
        }
        var24_24 = TiffFieldEnum.PlanarConfiguration.fromValue(var23_23);
        TIFFReader.LOGGER.info("Planary configuration: {}", (Object)var24_24);
        var25_25 = var1_1.getField(TiffTag.SAMPLE_FORMAT);
        var26_26 = var1_1.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        var27_27 = var1_1.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        var28_28 = 1;
        var29_29 = var1_1.getField(TiffTag.FILL_ORDER);
        if (var29_29 != null) {
            var28_28 = var29_29.getDataAsLong()[0];
        }
        var30_30 = false;
        if (var25_25 != null && var25_25.getDataAsLong()[0] == 3) {
            var30_30 = true;
            var31_31 = var17_17 <= 32 ? 3.4028234663852886E38 : 1.7976931348623157E308;
            v0 = var33_33 = var17_17 <= 32 ? 1.401298464324817E-45 : 4.9E-324;
            if (var17_17 <= 32 && var26_26 != null) {
                var31_31 = ((float[])var26_26.getData())[0];
            } else if (var17_17 > 32 && var26_26 != null) {
                var31_31 = ((double[])var26_26.getData())[0];
            }
            if (var17_17 <= 32 && var27_27 != null) {
                var33_33 = ((float[])var27_27.getData())[0];
            } else if (var17_17 > 32 && var27_27 != null) {
                var33_33 = ((double[])var27_27.getData())[0];
            }
            TIFFReader.LOGGER.info("Sample MAX value: {}", (Object)var31_31);
            TIFFReader.LOGGER.info("Sample MIN vlaue: {}", (Object)var33_33);
        }
        var31_32 = false;
        var32_35 = false;
        var33_34 = var19_19;
        var34_36 = 1;
        var35_37 = var1_1.getField(TiffTag.EXTRA_SAMPLES);
        if (var35_37 != null) {
            var32_35 = var35_37.getDataAsLong()[0] == 1;
        }
        var36_38 = 0;
        var37_39 = null;
        var38_40 = null;
        var39_41 = TIFFTweaker.getUncompressedStripByteCounts(var1_1, var7_7.length);
        var40_42 = new int[var19_19];
        if (var23_23 == 2) {
            var41_43 = var39_41.length / var19_19;
            var42_45 = 0;
            var43_46 = var41_43;
            for (var44_47 = 0; var44_47 < var19_19; ++var44_47) {
                for (var45_48 = var42_45; var45_48 < var43_46; ++var45_48) {
                    v1 = var44_47;
                    var40_42[v1] = var40_42[v1] + var39_41[var45_48];
                }
                var42_45 += var41_43;
                var43_46 += var41_43;
            }
        }
        switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$PhotoMetric[var15_15.ordinal()]) {
            case 1: {
                var41_44 = (short[])var1_1.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[var41_44.length / 3];
                var42_45 = 1 << var17_17;
                var43_46 = var42_45 << 1;
                var45_48 = 0;
                for (var44_47 = 0; var44_47 < var41_44.length / 3; ++var44_47) {
                    this.rgbColorPalette[var45_48++] = -16777216 | (var41_44[var44_47] & 65280) << 8 | var41_44[var44_47 + var42_45] & 65280 | (var41_44[var44_47 + var43_46] & 65280) >> 8;
                }
                var44_47 = (var9_9 * var17_17 + 7) / 8;
                var38_40 = new byte[var44_47 * var10_10];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                            var46_59 = var39_41[var45_48];
                            this.randIS.seek(var7_7[var45_48]);
                            this.randIS.readFully(var38_40, var36_38, var46_59);
                            var36_38 += var46_59;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                            var46_59 = var39_41[var45_48];
                            this.unpackStrip(var38_40, var36_38, var39_41[var45_48], var7_7[var45_48], var8_8[var45_48]);
                            var36_38 += var46_59;
                        }
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var45_48 = 0; var45_48 < var8_8.length; ++var45_48) {
                        var46_60 = null;
                        this.randIS.seek(var7_7[var45_48]);
                        if (var8_8[var45_48] == 0) {
                            var46_60 = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            var46_60 = new byte[var8_8[var45_48]];
                            this.randIS.readFully(var46_60);
                        }
                        var37_39.setInput(var46_60);
                        var47_66 = var37_39.decode(var38_40, var36_38, var39_41[var45_48]);
                        var36_38 += var47_66;
                    }
                }
                var45_49 = new DataBufferByte(var38_40, var38_40.length);
                var46_61 = null;
                if (var17_17 != 8) {
                    var46_61 = Raster.createPackedRaster(var45_49, var9_9, var10_10, var17_17, null);
                } else {
                    var47_67 = new int[]{0};
                    var46_61 = Raster.createInterleavedRaster(var45_49, var9_9, var10_10, var9_9, 1, var47_67, null);
                }
                var47_68 = new IndexColorModel(var17_17, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                return new BufferedImage(var47_68, var46_61, false, null);
            }
            case 2: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var48_73 = var44_47 * var10_10;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var48_73];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var49_74 = 0; var49_74 < var8_8.length; ++var49_74) {
                            var50_76 = var39_41[var49_74];
                            this.randIS.seek(var7_7[var49_74]);
                            this.randIS.readFully(var38_40, var36_38, var50_76);
                            var36_38 += var50_76;
                        }
                        break;
                    }
                    case 5: {
                        for (var49_74 = 0; var49_74 < var8_8.length; ++var49_74) {
                            var50_76 = var39_41[var49_74];
                            this.unpackStrip(var38_40, var36_38, var39_41[var49_74], var7_7[var49_74], var8_8[var49_74]);
                            var36_38 += var50_76;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var49_74 = 0; var49_74 < var8_8.length; ++var49_74) {
                        this.randIS.seek(var7_7[var49_74]);
                        var50_77 = null;
                        if (var8_8[var49_74] == 0) {
                            var50_77 = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            var50_77 = new byte[var8_8[var49_74]];
                            this.randIS.readFully(var50_77);
                        }
                        var37_39.setInput(var50_77);
                        var51_79 = var37_39.decode(var38_40, var36_38, var39_41[var49_74]);
                        var36_38 += var51_79;
                    }
                }
                if (var21_21 == 2 && var23_23 == 1) {
                    var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                }
                var45_50 /* !! */  = new DataBufferByte(var38_40, var38_40.length);
                var49_75 = var1_1.getField(TiffTag.ICC_PROFILE);
                var50_78 = null;
                if (var49_75 != null) {
                    var50_78 = ICC_Profile.getInstance((byte[])var49_75.getData());
                }
                var51_80 /* !! */  = CMYKColorSpace.getInstance();
                if (var50_78 != null) {
                    var51_80 /* !! */  = new ICC_ColorSpace(var50_78);
                }
                var52_81 = new int[]{0, 1, 2, 3};
                var53_84 = new int[]{var17_17, var17_17, var17_17, var17_17};
                if (var19_19 >= 5) {
                    var52_81 = new int[]{0, 1, 2, 3, 4};
                    var53_84 = new int[]{var17_17, var17_17, var17_17, var17_17, var17_17};
                    var34_36 = 3;
                    var31_32 = true;
                }
                if (var17_17 == 16) {
                    var54_87 = ArrayUtils.toShortArray(var38_40, this.endian == 19789);
                    var45_50 /* !! */  = new DataBufferUShort(var54_87, var54_87.length);
                    var47_69 = new ComponentColorModel(var51_80 /* !! */ , var53_84, var31_32, var32_35, var34_36, 1);
                    if (var23_23 == 2) {
                        var52_81 = new int[]{0, var40_42[0] * 8 / var17_17, (var40_42[0] + var40_42[1]) * 8 / var17_17, (var40_42[0] + var40_42[1] + var40_42[2]) * 8 / var17_17};
                        var55_90 = new int[]{0, 0, 0, 0};
                        if (var19_19 >= 5) {
                            var52_81 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2], var40_42[0] + var40_42[1] + var40_42[2] + var40_42[3]};
                            var55_90 = new int[]{0, 0, 0, 0, 0};
                        }
                        var46_62 = Raster.createBandedRaster(var45_50 /* !! */ , var9_9, var10_10, var44_47 * 8 / var17_17, var55_90, var52_81, null);
                    } else {
                        var46_62 = Raster.createInterleavedRaster(var45_50 /* !! */ , var9_9, var10_10, var9_9 * var33_34, var33_34, var52_81, null);
                    }
                    if (var50_78 != null) {
                        var46_62 = IMGUtils.iccp2rgbRaster(var46_62, var47_69);
                        var47_69 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, var46_62.getTransferType());
                    }
                } else {
                    var47_69 = new ComponentColorModel(var51_80 /* !! */ , var53_84, var31_32, var32_35, var34_36, 0);
                    if (var23_23 == 2) {
                        var52_81 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2]};
                        var54_88 = new int[]{0, 0, 0, 0};
                        if (var19_19 >= 5) {
                            var52_81 = new int[]{0, var40_42[0], var40_42[0] + var40_42[1], var40_42[0] + var40_42[1] + var40_42[2], var40_42[0] + var40_42[1] + var40_42[2] + var40_42[3]};
                            var54_88 = new int[]{0, 0, 0, 0, 0};
                        }
                        var46_62 = Raster.createBandedRaster(var45_50 /* !! */ , var9_9, var10_10, var44_47, var54_88, var52_81, null);
                    } else {
                        var46_62 = Raster.createInterleavedRaster(var45_50 /* !! */ , var9_9, var10_10, var9_9 * var33_34, var33_34, var52_81, null);
                    }
                    if (var50_78 != null) {
                        var46_62 = IMGUtils.iccp2rgbRaster(var46_62, var47_69);
                        var47_69 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_84, var31_32, var32_35, var34_36, 0);
                    }
                }
                return new BufferedImage(var47_69, var46_62, false, null);
            }
            case 3: {
                var54_89 = new int[]{2, 2};
                var55_91 = var1_1.getField(TiffTag.YCbCr_SUB_SAMPLING);
                if (var55_91 != null) {
                    var54_89 = var55_91.getDataAsLong();
                }
                var56_92 = (var9_9 + var54_89[0] - 1) / var54_89[0] * var54_89[0];
                var57_93 = (var10_10 + var54_89[1] - 1) / var54_89[1] * var54_89[1];
                var58_94 = 0.0f;
                var59_95 = 255.0f;
                var60_96 = 128.0f;
                var61_97 = 255.0f;
                var62_98 = 128.0f;
                var63_99 = 255.0f;
                var64_100 = 255.0f;
                var65_101 = 127.0f;
                var66_102 = var1_1.getField(TiffTag.REFERENCE_BLACK_WHITE);
                if (var66_102 != null) {
                    var67_103 = var66_102.getDataAsLong();
                    var58_94 = 1.0f * (float)var67_103[0] / (float)var67_103[1];
                    var59_95 = 1.0f * (float)var67_103[2] / (float)var67_103[3];
                    var60_96 = 1.0f * (float)var67_103[4] / (float)var67_103[5];
                    var61_97 = 1.0f * (float)var67_103[6] / (float)var67_103[7];
                    var62_98 = 1.0f * (float)var67_103[8] / (float)var67_103[9];
                    var63_99 = 1.0f * (float)var67_103[10] / (float)var67_103[11];
                }
                var67_104 = 0.299f;
                var68_105 = 0.587f;
                var69_106 = 0.114f;
                var70_107 = var1_1.getField(TiffTag.YCbCr_COEFFICIENTS);
                if (var70_107 != null) {
                    var71_108 = var70_107.getDataAsLong();
                    var67_104 = 1.0f * (float)var71_108[0] / (float)var71_108[1];
                    var68_105 = 1.0f * (float)var71_108[2] / (float)var71_108[3];
                    var69_106 = 1.0f * (float)var71_108[4] / (float)var71_108[5];
                }
                var71_109 = 0;
                var72_110 = var56_92 * var57_93;
                var38_40 = new byte[var72_110 * 3];
                var73_111 = null;
                var74_114 = null;
                if (var23_23 != 1) ** GOTO lbl337
                var75_115 = var54_89[0] * var54_89[1];
                var76_119 = 1;
                var77_123 = 1;
                var78_137 = var75_115 + var76_119 + var77_123;
                var79_144 = var56_92 / var54_89[0];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var80_148 = 0; var80_148 < var8_8.length; ++var80_148) {
                            this.randIS.seek(var7_7[var80_148]);
                            if (var8_8[var80_148] == 0) {
                                var73_111 = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                var73_111 = new byte[var8_8[var80_148]];
                                this.randIS.readFully(var73_111);
                            }
                            var81_159 = var73_111.length / var78_137;
                            var71_109 = this.upsampling(var71_109, var81_159, var75_115, var54_89, var58_94, var59_95, var60_96, var61_97, var62_98, var63_99, var64_100, var65_101, var67_104, var68_105, var69_106, var73_111, var38_40, var56_92, var79_144);
                        }
                        ** GOTO lbl407
                    }
                    case 2: {
                        for (var80_149 = 0; var80_149 < var8_8.length; ++var80_149) {
                            this.randIS.seek(var7_7[var80_149]);
                            if (var8_8[var80_149] == 0) {
                                var73_111 = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                var73_111 = new byte[var8_8[var80_149]];
                                this.randIS.readFully(var73_111);
                            }
                            var74_114 = new byte[var39_41[var80_149]];
                            var37_39 = new LZWTreeDecoder(8, true);
                            var37_39.setInput(var73_111);
                            var81_160 = var37_39.decode(var74_114, 0, var74_114.length);
                            var82_170 = var81_160 / var78_137;
                            var71_109 = this.upsampling(var71_109, var82_170, var75_115, var54_89, var58_94, var59_95, var60_96, var61_97, var62_98, var63_99, var64_100, var65_101, var67_104, var68_105, var69_106, var74_114, var38_40, var56_92, var79_144);
                        }
                        ** GOTO lbl407
                    }
                    case 5: {
                        for (var80_150 = 0; var80_150 < var8_8.length; ++var80_150) {
                            this.randIS.seek(var7_7[var80_150]);
                            if (var8_8[var80_150] == 0) {
                                var73_111 = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                var73_111 = new byte[var8_8[var80_150]];
                                this.randIS.readFully(var73_111);
                            }
                            var74_114 = new byte[var39_41[var80_150]];
                            Packbits.unpackbits(var73_111, var74_114);
                            var81_161 = var39_41[var80_150];
                            var82_171 = var81_161 / var78_137;
                            var71_109 = this.upsampling(var71_109, var82_171, var75_115, var54_89, var58_94, var59_95, var60_96, var61_97, var62_98, var63_99, var64_100, var65_101, var67_104, var68_105, var69_106, var74_114, var38_40, var56_92, var79_144);
                        }
                        ** GOTO lbl407
                    }
                }
                ** GOTO lbl407
lbl337:
                // 1 sources

                if (var8_8.length == 1 && var19_19 != 1) {
                    throw new RuntimeException("stripByteCounts length 1 is not consistent with samplesPerPixel " + var19_19);
                }
                var44_47 = (var56_92 * var17_17 + 7) / 8;
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        var75_116 = var8_8.length / var19_19;
                        var76_120 = new byte[var19_19][];
                        var77_124 = new ByteArrayOutputStream();
                        var79_145 = 0;
                        for (var78_138 = 0; var78_138 < var19_19; ++var78_138) {
                            var80_151 = 0;
                            while (var80_151 < var75_116) {
                                this.randIS.seek(var7_7[var79_145]);
                                var81_162 = var8_8[var79_145];
                                if (var81_162 == 0) {
                                    var73_111 = IOUtils.readFully((InputStream)this.randIS, 4096);
                                } else {
                                    var73_111 = new byte[var81_162];
                                    this.randIS.readFully(var73_111);
                                }
                                var77_124.write(var73_111);
                                ++var80_151;
                                ++var79_145;
                            }
                            var76_120[var78_138] = var77_124.toByteArray();
                            var77_124.reset();
                        }
                        var78_138 = 0;
                        var79_145 = 0;
                        var80_151 = 0;
                        var81_162 = 0;
                        var82_172 = var54_89[0] * var54_89[1];
                        var83_174 = 1;
                        for (var84_175 = 0; var84_175 < var57_93; ++var84_175) {
                            var85_176 = 0;
                            while (var85_176 < var56_92) {
                                var86_177 = var76_120[0][var78_138] & 255;
                                var87_178 = var76_120[1][var79_145] & 255;
                                var88_179 = var76_120[2][var80_151] & 255;
                                if (var83_174 % var82_172 == 0) {
                                    ++var79_145;
                                    ++var80_151;
                                }
                                var89_180 = ((float)var86_177 - var58_94) * var64_100 / (var59_95 - var58_94);
                                var90_181 = ((float)var87_178 - var60_96) * var65_101 / (var61_97 - var60_96);
                                var91_182 = ((float)var88_179 - var62_98) * var65_101 / (var63_99 - var62_98);
                                var92_183 = var91_182 * (2.0f - 2.0f * var67_104) + var89_180;
                                var93_184 = var90_181 * (2.0f - 2.0f * var69_106) + var89_180;
                                var94_185 = (var89_180 - var69_106 * var93_184 - var67_104 * var92_183) / var68_105;
                                if (var92_183 < 0.0f) {
                                    var92_183 = 0.0f;
                                }
                                if (var92_183 > 255.0f) {
                                    var92_183 = 255.0f;
                                }
                                if (var94_185 < 0.0f) {
                                    var94_185 = 0.0f;
                                }
                                if (var94_185 > 255.0f) {
                                    var94_185 = 255.0f;
                                }
                                if (var93_184 < 0.0f) {
                                    var93_184 = 0.0f;
                                }
                                if (var93_184 > 255.0f) {
                                    var93_184 = 255.0f;
                                }
                                var95_186 = 3 * var81_162;
                                var38_40[var95_186] = (byte)var92_183;
                                var38_40[var95_186 + 1] = (byte)var94_185;
                                var38_40[var95_186 + 2] = (byte)var93_184;
                                ++var85_176;
                                ++var78_138;
                                ++var81_162;
                                ++var83_174;
                            }
                        }
                        break;
                    }
                }
lbl407:
                // 6 sources

                var45_51 = new DataBufferByte(var38_40, var38_40.length);
                var52_82 = new int[]{0, 1, 2};
                var31_32 = false;
                var33_34 = var19_19;
                var34_36 = 1;
                var53_85 = new int[]{8, 8, 8};
                var46_63 = Raster.createInterleavedRaster(var45_51, var56_92, var57_93, var56_92 * var33_34, var33_34, var52_82, null);
                var47_70 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_85, var31_32, var32_35, var34_36, 0);
                return new BufferedImage(var47_70, var46_63, false, null).getSubimage(0, 0, var9_9, var10_10);
            }
            case 4: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var75_117 = var10_10 * var44_47;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var75_117];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var76_121 = 0; var76_121 < var8_8.length; ++var76_121) {
                            var77_125 = var39_41[var76_121];
                            this.randIS.seek(var7_7[var76_121]);
                            this.randIS.readFully(var38_40, var36_38, var77_125);
                            var36_38 += var77_125;
                        }
                        if (var28_28 != 2) break;
                        ArrayUtils.reverseBits(var38_40);
                        break;
                    }
                    case 5: {
                        for (var76_121 = 0; var76_121 < var8_8.length; ++var76_121) {
                            var77_125 = var39_41[var76_121];
                            this.unpackStrip(var38_40, var36_38, var39_41[var76_121], var7_7[var76_121], var8_8[var76_121]);
                            var36_38 += var77_125;
                        }
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                }
                if (var37_39 != null) {
                    var38_40 = new byte[var7_7.length * var39_41[0]];
                    for (var76_121 = 0; var76_121 < var8_8.length; ++var76_121) {
                        this.randIS.seek(var7_7[var76_121]);
                        if (var8_8[var76_121] == 0) {
                            var73_112 = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            var73_112 = new byte[var8_8[var76_121]];
                            this.randIS.readFully(var73_112);
                        }
                        if (var28_28 == 2) {
                            ArrayUtils.reverseBits(var73_112);
                        }
                        var37_39.setInput(var73_112);
                        var77_125 = var37_39.decode(var38_40, var36_38, var39_41[var76_121]);
                        var36_38 += var77_125;
                    }
                }
                if (var21_21 == 2) {
                    if (var23_23 == 1) {
                        var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                    } else {
                        var76_121 = 0;
                        for (var77_125 = 0; var77_125 < var19_19; ++var77_125) {
                            TIFFReader.applyDePredictor2(var38_40, var76_121, var9_9, var10_10);
                            var76_121 += var40_42[var77_125];
                        }
                    }
                }
                var47_71 = null;
                var46_64 = null;
                var52_83 = new int[var19_19];
                var53_86 = new int[var19_19];
                var33_34 = var19_19;
                var76_122 = new int[var19_19];
                Arrays.fill(var53_86, var17_17 <= 32 ? var17_17 : 32);
                if (var23_23 == 2) {
                    for (var77_125 = 0; var77_125 < var19_19; ++var77_125) {
                        var52_83[var77_125] = 0;
                        var76_122[var77_125] = var77_125;
                    }
                } else {
                    for (var77_125 = 0; var77_125 < var19_19; ++var77_125) {
                        var52_83[var77_125] = var77_125;
                        var76_122[var77_125] = 0;
                    }
                }
                var31_32 = false;
                var34_36 = 1;
                if (var19_19 == 4) {
                    var34_36 = 3;
                    var31_32 = true;
                }
                if (var23_23 != 2) ** GOTO lbl568
                var77_126 = new byte[var19_19][];
                var78_139 = 0;
                var79_146 = 0;
                for (var80_152 = 0; var80_152 < var19_19; ++var80_152) {
                    var77_126[var80_152] = ArrayUtils.subArray(var38_40, var78_139, var40_42[var80_152]);
                    var78_139 += var40_42[var80_152];
                }
                if (var30_30) {
                    if (var17_17 == 16 || var17_17 == 32) {
                        var80_153 /* !! */  = new float[var19_19][];
                        if (var17_17 == 16) {
                            for (var81_163 = 0; var81_163 < var19_19; ++var81_163) {
                                var80_153 /* !! */ [var81_163] = ArrayUtils.to16BitFloatArray(var77_126[var81_163], this.endian == 19789);
                            }
                        } else {
                            for (var81_164 = 0; var81_164 < var19_19; ++var81_164) {
                                var80_153 /* !! */ [var81_164] = ArrayUtils.toFloatArray(var77_126[var81_164], this.endian == 19789);
                            }
                        }
                        var79_146 = 4;
                        var45_52 /* !! */  = new DataBufferFloat(var80_153 /* !! */ , var80_153 /* !! */ [0].length);
                    } else if (var17_17 == 64) {
                        var80_153 /* !! */  = (float[][])new double[var19_19][];
                        for (var81_165 = 0; var81_165 < var19_19; ++var81_165) {
                            var80_153 /* !! */ [var81_165] = (float[])ArrayUtils.toDoubleArray(var77_126[var81_165], this.endian == 19789);
                        }
                        var79_146 = 5;
                        var45_52 /* !! */  = new DataBufferDouble(var80_153 /* !! */ , var80_153 /* !! */ [0].length);
                    } else {
                        throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + var17_17);
                    }
                    var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, var79_146);
                    var80_153 /* !! */  = (float[][])new BandedSampleModel(var79_146, var9_9, var10_10, var9_9, var76_122, var52_83);
                    var46_64 = Raster.createWritableRaster((SampleModel)var80_153 /* !! */ , var45_52 /* !! */ , null);
                } else {
                    if (var17_17 == 16) {
                        var80_154 = new short[var19_19][];
                        for (var81_166 = 0; var81_166 < var19_19; ++var81_166) {
                            var80_154[var81_166] = ArrayUtils.toShortArray(var77_126[var81_166], this.endian == 19789);
                        }
                        var45_53 /* !! */  = new DataBufferUShort(var80_154, var80_154[0].length);
                        var79_146 = 1;
                    } else if (var17_17 > 8 && var17_17 < 16) {
                        var80_155 = new short[var19_19][];
                        for (var81_167 = 0; var81_167 < var19_19; ++var81_167) {
                            var80_155[var81_167] = (short[])ArrayUtils.toNBits(var17_17, var77_126[var81_167], var9_9, true);
                        }
                        var45_53 /* !! */  = new DataBufferUShort(var80_155, var80_155[0].length);
                        var79_146 = 1;
                    } else if (var17_17 > 16) {
                        var80_156 = new int[var19_19][];
                        var81_168 = false;
                        if (var17_17 % 8 == 0) {
                            var81_168 = true;
                        }
                        for (var82_173 = 0; var82_173 < var19_19; ++var82_173) {
                            var80_156[var82_173] = (int[])ArrayUtils.toNBits(var17_17, var77_126[var82_173], var19_19 * var9_9, var81_168);
                        }
                        var45_53 /* !! */  = new DataBufferInt(var80_156, var80_156[0].length);
                        var79_146 = 3;
                    } else if (var17_17 < 8) {
                        var80_157 = new byte[var19_19][];
                        for (var81_169 = 0; var81_169 < var19_19; ++var81_169) {
                            var80_157[var81_169] = (byte[])ArrayUtils.toNBits(var17_17, var77_126[var81_169], var9_9, true);
                        }
                        var45_53 /* !! */  = new DataBufferByte(var80_157, var80_157[0].length);
                        var79_146 = 0;
                    } else {
                        var45_53 /* !! */  = new DataBufferByte(var77_126, var77_126[0].length);
                        var79_146 = 0;
                    }
                    var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, var79_146);
                    var46_64 = Raster.createBandedRaster(var45_53 /* !! */ , var9_9, var10_10, var9_9, var76_122, var52_83, null);
                }
                ** GOTO lbl602
lbl568:
                // 1 sources

                if (!var30_30) ** GOTO lbl587
                if (var17_17 < 16 || var17_17 > 32) ** GOTO lbl579
                if (var17_17 % 8 == 0) {
                    var77_127 = null;
                    var77_127 = var17_17 == 16 ? ArrayUtils.to16BitFloatArray(var38_40, this.endian == 19789) : (var17_17 == 24 ? ArrayUtils.to24BitFloatArray(var38_40, this.endian == 19789) : ArrayUtils.toFloatArray(var38_40, this.endian == 19789));
                    var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, 4);
                    var45_54 = new DataBufferFloat(var77_127, var77_127.length);
                    var78_140 = new PixelInterleavedSampleModel(4, var9_9, var10_10, var19_19, var9_9 * var19_19, var52_83);
                    var46_64 = Raster.createWritableRaster(var78_140, var45_54, null);
                } else {
                    throw new UnsupportedOperationException("Unsupported bit depth: " + var17_17);
lbl579:
                    // 1 sources

                    if (var17_17 == 64) {
                        var77_128 = ArrayUtils.toDoubleArray(var38_40, this.endian == 19789);
                        var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, 5);
                        var45_55 = new DataBufferDouble(var77_128, var77_128.length);
                        var78_141 = new PixelInterleavedSampleModel(5, var9_9, var10_10, var19_19, var9_9 * var19_19, var52_83);
                        var46_64 = Raster.createWritableRaster(var78_141, var45_55, null);
                    } else {
                        throw new UnsupportedOperationException("Unsupported bit depth: " + var17_17);
lbl587:
                        // 1 sources

                        if (var17_17 < 8) {
                            var77_129 = ArrayUtils.toNBits(var17_17 * var19_19, var38_40, var9_9, true);
                            var47_71 = new DirectColorModel(var17_17 * var19_19, TIFFReader.redMask[var17_17], TIFFReader.greenMask[var17_17], TIFFReader.blueMask[var17_17]);
                            var46_64 = var47_71.createCompatibleWritableRaster(var9_9, var10_10);
                            var46_64.setDataElements(0, 0, var9_9, var10_10, var77_129);
                        } else if (var17_17 == 8) {
                            var47_71 = new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, 0);
                            var45_56 = new DataBufferByte(var38_40, var38_40.length);
                            var46_64 = Raster.createInterleavedRaster(var45_56, var9_9, var10_10, var9_9 * var33_34, var33_34, var52_83, null);
                        } else {
                            var77_130 = ArrayUtils.toNBits(var17_17, var38_40, var19_19 * var9_9, var17_17 % 8 == 0 ? this.endian == 19789 : true);
                            var47_71 = var17_17 <= 16 ? new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, 1) : (var17_17 == 32 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), var31_32) : new ComponentColorModel(ColorSpace.getInstance(1000), var53_86, var31_32, var32_35, var34_36, 3));
                            var46_64 = var47_71.createCompatibleWritableRaster(var9_9, var10_10);
                            var46_64.setDataElements(0, 0, var9_9, var10_10, var77_130);
                        }
                    }
                }
lbl602:
                // 7 sources

                return new BufferedImage(var47_71, var46_64, false, null);
            }
            case 5: 
            case 6: {
                var44_47 = var19_19 * ((var9_9 * var17_17 + 7) / 8);
                var75_118 = var10_10 * var44_47;
                if (var23_23 == 2) {
                    var44_47 = (var9_9 * var17_17 + 7) / 8;
                }
                var38_40 = new byte[var75_118];
                switch (var17_17) {
                    case 1: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.BLACK_WHITE_PALETTE : TIFFReader.BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 2: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.FOUR_COLOR_PALETTE : TIFFReader.FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 4: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.SIXTEEN_COLOR_PALETTE : TIFFReader.SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 8: {
                        this.rgbColorPalette = var15_15 == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.EIGHT_BIT_COLOR_PALETTE : TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                }
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var77_131 = 0; var77_131 < var8_8.length; ++var77_131) {
                            var78_142 = var39_41[var77_131];
                            this.randIS.seek(var7_7[var77_131]);
                            this.randIS.readFully(var38_40, var36_38, var78_142);
                            var36_38 += var78_142;
                        }
                        if (var28_28 != 2) break;
                        ArrayUtils.reverseBits(var38_40);
                        break;
                    }
                    case 6: {
                        var37_39 = new G31DDecoder(var9_9, var12_12);
                        break;
                    }
                    case 7: {
                        var77_132 = var1_1.getField(TiffTag.T4_OPTIONS);
                        var78_142 = 0;
                        if (var77_132 != null) {
                            var78_142 = var77_132.getDataAsLong()[0];
                        }
                        if ((var78_142 & TIFFReader.GROUP3OPT_UNCOMPRESSED) == TIFFReader.GROUP3OPT_UNCOMPRESSED) {
                            throw new UnsupportedCompressionException("Group 3 Uncompressed mode is not supported");
                        }
                        if ((var78_142 & TIFFReader.GROUP3OPT_2DENCODING) == TIFFReader.GROUP3OPT_2DENCODING) {
                            var37_39 = new G32DDecoder(var9_9, var12_12);
                            break;
                        }
                        var37_39 = new G32DDecoder(var9_9, var12_12, true);
                        break;
                    }
                    case 2: {
                        var37_39 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var37_39 = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (var79_147 = 0; var79_147 < var8_8.length; ++var79_147) {
                            var80_158 = var39_41[var79_147];
                            this.unpackStrip(var38_40, var36_38, var39_41[var79_147], var7_7[var79_147], var8_8[var79_147]);
                            var36_38 += var80_158;
                        }
                        break;
                    }
                }
                if (var37_39 != null) {
                    for (var77_133 = 0; var77_133 < var8_8.length; ++var77_133) {
                        this.randIS.seek(var7_7[var77_133]);
                        if (var8_8[var77_133] == 0) {
                            var73_113 = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            var73_113 = new byte[var8_8[var77_133]];
                            this.randIS.readFully(var73_113);
                        }
                        if (var28_28 == 2) {
                            ArrayUtils.reverseBits(var73_113);
                        }
                        var37_39.setInput(var73_113);
                        var78_142 = var37_39.decode(var38_40, var36_38, var39_41[var77_133]);
                        var36_38 += var78_142;
                    }
                }
                if (var17_17 <= 8) {
                    if (var21_21 == 2 && var23_23 == 1) {
                        var38_40 = TIFFReader.applyDePredictor(var19_19, var38_40, var9_9, var10_10);
                    }
                    var45_57 = new DataBufferByte(var38_40, var38_40.length);
                    var47_72 = new IndexColorModel(var17_17, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                    var46_65 = Raster.createPackedRaster(var45_57, var9_9, var10_10, var17_17, null);
                    if (var19_19 == 2) {
                        if (var15_15 == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                            IMGUtils.invertBits(var38_40, 2);
                        }
                        var33_34 = var19_19;
                        var77_134 = new int[]{0, 0, 0, 1};
                        var31_32 = true;
                        var34_36 = 3;
                        var47_72 = new ComponentColorModel(ColorSpace.getInstance(1000), var31_32, var32_35, var34_36, 0);
                        var46_65 = Raster.createInterleavedRaster(var45_57, var9_9, var10_10, var9_9 * var33_34, var33_34, var77_134, null);
                    }
                } else if (var17_17 <= 16) {
                    var77_135 = (short[])ArrayUtils.toNBits(var17_17, var38_40, var19_19 * var9_9, var17_17 % 8 == 0 ? this.endian == 19789 : true);
                    if (var21_21 == 2 && var23_23 == 1) {
                        var77_135 = TIFFReader.applyDePredictor(var19_19, var77_135, var9_9, var10_10);
                    }
                    if (var15_15 == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                        IMGUtils.invertBits(var77_135, var19_19);
                    }
                    if (var19_19 == 2) {
                        var31_32 = true;
                        var34_36 = 3;
                    }
                    var47_72 = new ComponentColorModel(ColorSpace.getInstance(1003), var31_32, var32_35, var34_36, 1);
                    var46_65 = var47_72.createCompatibleWritableRaster(var9_9, var10_10);
                    var46_65.setDataElements(0, 0, var9_9, var10_10, var77_135);
                } else if (var17_17 == 64) {
                    var77_136 = ArrayUtils.toDoubleArray(var38_40, this.endian == 19789);
                    var47_72 = new ComponentColorModel(ColorSpace.getInstance(1000), null, var31_32, var32_35, var34_36, 5);
                    var45_58 = new DataBufferDouble(var77_136, var77_136.length);
                    var78_143 = new PixelInterleavedSampleModel(5, var9_9, var10_10, var19_19, var9_9 * var19_19, new int[]{0, 0, 0});
                    var46_65 = Raster.createWritableRaster(var78_143, var45_58, null);
                } else {
                    throw new UnsupportedOperationException("Unsupported bit depth: " + var17_17);
                }
                return new BufferedImage(var47_72, var46_65, false, null);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private BufferedImage decodeTiledTiff(IFD var1_1) throws Exception {
        var2_2 = var1_1.getField(TiffTag.COMPRESSION);
        var3_3 = (short[])var2_2.getData();
        var4_4 = TiffFieldEnum.Compression.fromValue(var3_3[0] & 65535);
        TIFFReader.LOGGER.info("Compression type: {}", (Object)var4_4.getDescription());
        var5_5 = var1_1.getField(TiffTag.TILE_OFFSETS);
        if (var5_5 == null) {
            var5_5 = var1_1.getField(TiffTag.STRIP_OFFSETS);
        }
        if (var5_5 == null) {
            throw new RuntimeException("Missing required field tileOffsets");
        }
        var6_6 = var5_5.getDataAsLong();
        var7_7 = var1_1.getField(TiffTag.TILE_BYTE_COUNTS);
        if (var7_7 == null) {
            var7_7 = var1_1.getField(TiffTag.STRIP_BYTE_COUNTS);
        }
        var8_8 = null;
        if (var7_7 != null) ** GOTO lbl20
        if (var6_6.length == 1) {
            var8_8 = new int[]{0};
        } else {
            throw new RuntimeException("Missing required field tileByteCounts");
lbl20:
            // 1 sources

            var8_8 = var7_7.getDataAsLong();
        }
        var9_9 = var1_1.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        var10_10 = var1_1.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        TIFFReader.LOGGER.info("Image width: {}", (Object)var9_9);
        TIFFReader.LOGGER.info("Image height: {}", (Object)var10_10);
        var11_11 = var1_1.getField(TiffTag.TILE_WIDTH);
        var12_12 = var1_1.getField(TiffTag.TILE_LENGTH);
        var13_13 = var9_9;
        if (var11_11 != null) {
            var13_13 = var11_11.getDataAsLong()[0];
        }
        var14_14 = var10_10;
        if (var12_12 != null) {
            var14_14 = var12_12.getDataAsLong()[0];
        }
        var15_15 = var1_1.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        var16_16 = TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue();
        if (var15_15 != null) {
            var16_16 = var15_15.getDataAsLong()[0];
        }
        var17_17 = TiffFieldEnum.PhotoMetric.fromValue(var16_16);
        TIFFReader.LOGGER.info("PhotoMetric: {}", (Object)var17_17);
        var18_18 = var1_1.getField(TiffTag.BITS_PER_SAMPLE);
        var19_19 = 1;
        if (var18_18 != null) {
            var19_19 = var18_18.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Bits per sample: {}", (Object)var19_19);
        var20_20 = var1_1.getField(TiffTag.SAMPLES_PER_PIXEL);
        var21_21 = 1;
        if (var20_20 != null) {
            var21_21 = var20_20.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Samples per pixel: {}", (Object)var21_21);
        var22_22 = var1_1.getField(TiffTag.PREDICTOR);
        var23_23 = 0;
        if (var22_22 != null) {
            var23_23 = var22_22.getDataAsLong()[0];
            TIFFReader.LOGGER.info("Predictor: {}", (Object)var23_23);
        }
        var24_24 = var1_1.getField(TiffTag.PLANAR_CONFIGURATTION);
        var25_25 = 1;
        if (var24_24 != null) {
            var25_25 = var24_24.getDataAsLong()[0];
        }
        var26_26 = TiffFieldEnum.PlanarConfiguration.fromValue(var25_25);
        TIFFReader.LOGGER.info("Planary configuration: {}", (Object)var26_26);
        var27_27 = var1_1.getField(TiffTag.SAMPLE_FORMAT);
        var28_28 = var1_1.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        var29_29 = var1_1.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        var30_30 = false;
        var31_31 = false;
        if (var27_27 != null && var27_27.getDataAsLong()[0] == 3) {
            var30_30 = true;
            var32_32 = var19_19 <= 32 ? 3.4028234663852886E38 : 1.7976931348623157E308;
            v0 = var34_34 = var19_19 <= 32 ? 1.401298464324817E-45 : 4.9E-324;
            if (var19_19 <= 32 && var28_28 != null) {
                var32_32 = ((float[])var28_28.getData())[0];
            } else if (var19_19 > 32 && var28_28 != null) {
                var32_32 = ((double[])var28_28.getData())[0];
            }
            if (var19_19 <= 32 && var29_29 != null) {
                var34_34 = ((float[])var29_29.getData())[0];
            } else if (var19_19 > 32 && var29_29 != null) {
                var34_34 = ((double[])var29_29.getData())[0];
            }
            TIFFReader.LOGGER.info("Sample MAX value: {}", (Object)var32_32);
            TIFFReader.LOGGER.info("Sample MIN vlaue: {}", (Object)var34_34);
        }
        var32_33 = (var9_9 + var13_13 - 1) / var13_13;
        var33_36 = (var10_10 + var14_14 - 1) / var14_14;
        var34_35 = var32_33 * var33_36;
        var35_37 = null;
        var36_38 = null;
        var37_39 = (var13_13 * var19_19 + 7) / 8 * var21_21 * var14_14;
        var38_40 = 0;
        var39_41 = 0;
        var40_42 = 0;
        var41_43 = null;
        var42_44 /* !! */  = null;
        var43_45 /* !! */  = null;
        switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$PhotoMetric[var17_17.ordinal()]) {
            case 1: {
                var44_46 = (short[])var1_1.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[var44_46.length / 3];
                var45_47 = 1 << var19_19;
                var46_48 = var45_47 << 1;
                var48_50 = 0;
                for (var47_49 = 0; var47_49 < var44_46.length / 3; ++var47_49) {
                    this.rgbColorPalette[var48_50++] = -16777216 | (var44_46[var47_49] & 65280) << 8 | var44_46[var47_49 + var45_47] & 65280 | (var44_46[var47_49 + var46_48] & 65280) >> 8;
                }
                var47_49 = var32_33 * (var13_13 * var19_19 + 7) / 8;
                var36_38 = new byte[var47_49 * var33_36 * var14_14];
                var48_51 = null;
                var42_44 /* !! */  = new DataBufferByte(var36_38, var36_38.length);
                var43_45 /* !! */  = new IndexColorModel(var19_19, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                if (var19_19 < 8) {
                    var41_43 = Raster.createPackedRaster(var42_44 /* !! */ , var13_13 * var32_33, var14_14 * var33_36, var19_19, null);
                } else {
                    var49_52 = new int[]{0};
                    if (var19_19 > 8) {
                        var48_51 = new short[var36_38.length / 2];
                        var42_44 /* !! */  = new DataBufferUShort(var48_51, var48_51.length);
                        var43_45 /* !! */  = new IndexColorModel(var19_19, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 1);
                    }
                    var41_43 = Raster.createInterleavedRaster(var42_44 /* !! */ , var13_13 * var32_33, var14_14 * var33_36, var13_13 * var32_33, 1, var49_52, null);
                }
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        for (var49_53 = 0; var49_53 < var8_8.length; ++var49_53) {
                            var50_56 = new byte[var8_8[var49_53]];
                            this.randIS.seek(var6_6[var49_53]);
                            this.randIS.readFully(var50_56);
                            if (var19_19 == 16) {
                                var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, ArrayUtils.toShortArray(var50_56, this.endian == 19789));
                            } else {
                                var51_58 /* !! */  = (byte[])new DataBufferByte(var50_56, var50_56.length);
                                var52_60 = Raster.createPackedRaster((DataBuffer)var51_58 /* !! */ , var13_13, var14_14, var19_19, null);
                                var41_43.setDataElements(var38_40, var39_41, var52_60);
                            }
                            var38_40 += var13_13;
                            if (++var40_42 < var32_33) continue;
                            var38_40 = 0;
                            var39_41 += var14_14;
                            var40_42 = 0;
                        }
                        break;
                    }
                    case 2: {
                        var35_37 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var35_37 = new DeflateDecoder();
                        break;
                    }
                }
                if (var35_37 != null) {
                    for (var49_54 = 0; var49_54 < var8_8.length; ++var49_54) {
                        var50_56 = new byte[var8_8[var49_54]];
                        var51_58 /* !! */  = new byte[var37_39];
                        this.randIS.seek(var6_6[var49_54]);
                        this.randIS.readFully(var50_56);
                        var35_37.setInput(var50_56);
                        var35_37.decode(var51_58 /* !! */ , 0, var37_39);
                        if (var19_19 == 16) {
                            var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, ArrayUtils.toShortArray(var51_58 /* !! */ , this.endian == 19789));
                        } else {
                            var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var51_58 /* !! */ );
                        }
                        var38_40 += var13_13;
                        if (++var40_42 < var32_33) continue;
                        var38_40 = 0;
                        var39_41 += var14_14;
                        var40_42 = 0;
                    }
                }
                return new BufferedImage(var43_45 /* !! */ , var41_43, false, null).getSubimage(0, 0, var9_9, var10_10);
            }
            case 4: {
                var49_55 = new int[var21_21];
                var50_57 = new int[var21_21];
                Arrays.fill(var50_57, var19_19);
                for (var51_59 = 0; var51_59 < var21_21; ++var51_59) {
                    var49_55[var51_59] = var51_59;
                }
                var51_59 = 0;
                var52_61 = 1;
                if (var21_21 >= 4) {
                    var52_61 = 3;
                    var51_59 = 1;
                }
                if (var30_30) {
                    if (var19_19 == 64) {
                        var43_45 /* !! */  = new ComponentColorModel(ColorSpace.getInstance(1000), var50_57, (boolean)var51_59, false, var52_61, 5);
                    } else if (var19_19 >= 16 && var19_19 <= 32) {
                        var43_45 /* !! */  = new ComponentColorModel(ColorSpace.getInstance(1000), var50_57, (boolean)var51_59, false, var52_61, 4);
                    }
                } else {
                    var43_45 /* !! */  = var19_19 < 8 ? new DirectColorModel(var19_19 * var21_21, TIFFReader.redMask[var19_19], TIFFReader.greenMask[var19_19], TIFFReader.blueMask[var19_19]) : (var19_19 == 16 ? new ComponentColorModel(ColorSpace.getInstance(1000), var50_57, (boolean)var51_59, var31_31, var52_61, 1) : (var19_19 == 24 ? new ComponentColorModel(ColorSpace.getInstance(1000), var50_57, (boolean)var51_59, var31_31, var52_61, 3) : (var19_19 == 32 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), (boolean)var51_59) : (var19_19 == 64 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), (boolean)var51_59) : new ComponentColorModel(ColorSpace.getInstance(1000), var50_57, (boolean)var51_59, var31_31, var52_61, 0)))));
                }
                var41_43 = var43_45 /* !! */ .createCompatibleWritableRaster(var13_13 * var32_33, var14_14 * var33_36);
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[var4_4.ordinal()]) {
                    case 1: {
                        if (var25_25 == 1) {
                            for (var53_62 = 0; var53_62 < var8_8.length; ++var53_62) {
                                var54_65 /* !! */  = new byte[var8_8[var53_62]];
                                this.randIS.seek(var6_6[var53_62]);
                                this.randIS.readFully(var54_65 /* !! */ );
                                if (var30_30) {
                                    var55_66 = null;
                                    if (var19_19 == 64) {
                                        var55_66 = ArrayUtils.toDoubleArray(var54_65 /* !! */ , this.endian == 19789);
                                    } else if (var19_19 == 32) {
                                        var55_66 = ArrayUtils.toFloatArray(var54_65 /* !! */ , this.endian == 19789);
                                    } else if (var19_19 == 24) {
                                        var55_66 = ArrayUtils.to24BitFloatArray(var54_65 /* !! */ , this.endian == 19789);
                                    } else if (var19_19 == 16) {
                                        var55_66 = ArrayUtils.to16BitFloatArray(var54_65 /* !! */ , this.endian == 19789);
                                    } else {
                                        throw new UnsupportedOperationException("Unsupported bit depth: " + var19_19);
                                    }
                                    var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var55_66);
                                } else if (var19_19 < 8) {
                                    var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, ArrayUtils.toNBits(var19_19 * var21_21, var54_65 /* !! */ , var13_13, true));
                                } else if (var19_19 == 8) {
                                    var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var54_65 /* !! */ );
                                } else if (var19_19 % 8 == 0) {
                                    var55_66 = ArrayUtils.toNBits(var19_19, var54_65 /* !! */ , var21_21 * var13_13, this.endian == 19789);
                                    var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var55_66);
                                } else {
                                    var55_66 = ArrayUtils.toNBits(var19_19, var54_65 /* !! */ , var21_21 * var13_13, true);
                                    var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var55_66);
                                }
                                var38_40 += var13_13;
                                if (++var40_42 < var32_33) continue;
                                var38_40 = 0;
                                var39_41 += var14_14;
                                var40_42 = 0;
                            }
                            break;
                        }
                        var53_63 = new byte[var21_21][];
                        var54_65 /* !! */  = null;
                        var55_66 = null;
                        var56_67 = new int[]{0, 1, 2};
                        var49_55 = new int[]{0, 0, 0};
                        var57_68 = 0;
                        for (var58_69 = 0; var58_69 < var34_35; ++var58_69) {
                            var53_63[0] = new byte[var8_8[var58_69]];
                            this.randIS.seek(var6_6[var58_69]);
                            this.randIS.readFully(var53_63[0]);
                            var59_70 = var58_69 + var34_35;
                            var53_63[1] = new byte[var8_8[var59_70]];
                            this.randIS.seek(var6_6[var59_70]);
                            this.randIS.readFully(var53_63[1]);
                            var60_71 = var59_70 + var34_35;
                            var53_63[2] = new byte[var8_8[var60_71]];
                            this.randIS.seek(var6_6[var60_71]);
                            this.randIS.readFully(var53_63[2]);
                            if (var30_30) {
                                if (var19_19 >= 16 && var19_19 <= 32) {
                                    var61_72 /* !! */  = new float[var21_21][];
                                    if (var19_19 == 16) {
                                        for (var62_74 = 0; var62_74 < var21_21; ++var62_74) {
                                            var61_72 /* !! */ [var62_74] = ArrayUtils.to16BitFloatArray(var53_63[var62_74], this.endian == 19789);
                                        }
                                    } else if (var19_19 == 24) {
                                        for (var62_74 = 0; var62_74 < var21_21; ++var62_74) {
                                            var61_72 /* !! */ [var62_74] = ArrayUtils.to24BitFloatArray(var53_63[var62_74], this.endian == 19789);
                                        }
                                    } else if (var19_19 == 32) {
                                        for (var62_74 = 0; var62_74 < var21_21; ++var62_74) {
                                            var61_72 /* !! */ [var62_74] = ArrayUtils.toFloatArray(var53_63[var62_74], this.endian == 19789);
                                        }
                                    }
                                    var55_66 = new DataBufferFloat(var61_72 /* !! */ , var61_72 /* !! */ [0].length);
                                    var57_68 = 4;
                                } else if (var19_19 == 64) {
                                    var61_72 /* !! */  = (float[][])new double[var21_21][];
                                    for (var62_74 = 0; var62_74 < var21_21; ++var62_74) {
                                        var61_72 /* !! */ [var62_74] = (float[])ArrayUtils.toDoubleArray(var53_63[var62_74], this.endian == 19789);
                                    }
                                    var55_66 = new DataBufferDouble(var61_72 /* !! */ , var61_72 /* !! */ [0].length);
                                    var57_68 = 5;
                                } else {
                                    throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + var19_19);
                                }
                                var61_72 /* !! */  = (float[][])new BandedSampleModel(var57_68, var13_13, var14_14, var13_13, var56_67, var49_55);
                                var54_65 /* !! */  = (byte[])Raster.createWritableRaster((SampleModel)var61_72 /* !! */ , (DataBuffer)var55_66, null);
                            } else {
                                if (var19_19 == 16) {
                                    var55_66 = new DataBufferUShort(new short[][]{ArrayUtils.toShortArray(var53_63[0], this.endian == 19789), ArrayUtils.toShortArray(var53_63[1], this.endian == 19789), ArrayUtils.toShortArray(var53_63[2], this.endian == 19789)}, var13_13 * var14_14);
                                } else if (var19_19 > 16 && var19_19 <= 32) {
                                    var61_73 = var19_19 % 8 == 0 ? this.endian == 19789 : true;
                                    var55_66 = new DataBufferInt(new int[][]{(int[])ArrayUtils.toNBits(var19_19, var53_63[0], var13_13, var61_73), (int[])ArrayUtils.toNBits(var19_19, var53_63[1], var13_13, var61_73), (int[])ArrayUtils.toNBits(var19_19, var53_63[2], var13_13, var61_73)}, var13_13 * var14_14);
                                } else {
                                    var55_66 = var19_19 == 64 ? (Object)new DataBufferInt(new int[][]{ArrayUtils.to32BitsLongArray(var53_63[0], this.endian == 19789), ArrayUtils.to32BitsLongArray(var53_63[1], this.endian == 19789), ArrayUtils.to32BitsLongArray(var53_63[2], this.endian == 19789)}, var13_13 * var14_14) : (Object)new DataBufferByte(var53_63, var53_63[0].length);
                                }
                                var54_65 /* !! */  = (byte[])Raster.createBandedRaster((DataBuffer)var55_66, var13_13, var14_14, var13_13, var56_67, var49_55, null);
                            }
                            var41_43.setRect(var38_40, var39_41, (Raster)var54_65 /* !! */ );
                            var38_40 += var13_13;
                            if (++var40_42 < var32_33) continue;
                            var38_40 = 0;
                            var39_41 += var14_14;
                            var40_42 = 0;
                        }
                        break;
                    }
                    case 5: {
                        for (var53_64 = 0; var53_64 < var8_8.length; ++var53_64) {
                            var54_65 /* !! */  = new byte[var8_8[var53_64]];
                            this.randIS.seek(var6_6[var53_64]);
                            this.randIS.readFully(var54_65 /* !! */ );
                            var55_66 = new byte[var37_39];
                            Packbits.unpackbits(var54_65 /* !! */ , (byte[])var55_66);
                            if (var19_19 == 16) {
                                var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, ArrayUtils.toShortArray((byte[])var55_66, this.endian == 19789));
                            } else {
                                var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var55_66);
                            }
                            var38_40 += var13_13;
                            if (++var40_42 < var32_33) continue;
                            var38_40 = 0;
                            var39_41 += var14_14;
                            var40_42 = 0;
                        }
                        break;
                    }
                    case 2: {
                        var35_37 = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        var35_37 = new DeflateDecoder();
                        break;
                    }
                }
                if (var35_37 != null) {
                    for (var53_62 = 0; var53_62 < var8_8.length; ++var53_62) {
                        var54_65 /* !! */  = new byte[var8_8[var53_62]];
                        var55_66 = new byte[var37_39];
                        this.randIS.seek(var6_6[var53_62]);
                        this.randIS.readFully(var54_65 /* !! */ );
                        var35_37.setInput(var54_65 /* !! */ );
                        var35_37.decode((byte[])var55_66, 0, var37_39);
                        if (var19_19 == 16) {
                            var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, ArrayUtils.toShortArray((byte[])var55_66, this.endian == 19789));
                        } else {
                            var41_43.setDataElements(var38_40, var39_41, var13_13, var14_14, var55_66);
                        }
                        var38_40 += var13_13;
                        if (++var40_42 < var32_33) continue;
                        var38_40 = 0;
                        var39_41 += var14_14;
                        var40_42 = 0;
                    }
                }
                if (var23_23 == 2 && var25_25 == 1 && this.bitsPerPixel == 8) {
                    var36_38 = TIFFReader.applyDePredictor(var21_21, var36_38, var9_9, var10_10);
                }
                return new BufferedImage(var43_45 /* !! */ , var41_43, false, null).getSubimage(0, 0, var9_9, var10_10);
            }
        }
        return null;
    }

    @Override
    public int getFrameCount() {
        if (this.frames != null) {
            return this.frames.size();
        }
        return super.getFrameCount();
    }

    @Override
    public BufferedImage getFrame(int n) {
        if (this.frames == null) {
            return null;
        }
        if (n >= 0 && n < this.frames.size()) {
            return this.frames.get(n);
        }
        throw new IllegalArgumentException("Frame index " + n + " out of bounds");
    }

    @Override
    public List<BufferedImage> getFrames() {
        if (this.frames != null) {
            return Collections.unmodifiableList(this.frames);
        }
        return Collections.emptyList();
    }

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        if (!this.readIFDs(inputStream)) {
            return null;
        }
        this.frames = new ArrayList<BufferedImage>();
        BufferedImage bufferedImage = null;
        for (IFD iFD : this.ifds) {
            try {
                bufferedImage = this.decode(iFD);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            if (bufferedImage == null) continue;
            this.frames.add(bufferedImage);
        }
        this.randIS.shallowClose();
        if (this.frames.size() > 0) {
            return this.frames.get(0);
        }
        return null;
    }

    private boolean readHeader(RandomAccessInputStream randomAccessInputStream) throws IOException {
        this.endian = randomAccessInputStream.readShort();
        if (this.endian == 19789) {
            LOGGER.info("Byte order: Motorola BIG_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (this.endian == 18761) {
            LOGGER.info("Byte order: Intel LITTLE_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            LOGGER.info("Warning: invalid TIFF byte order!");
            return false;
        }
        short s = randomAccessInputStream.readShort();
        if (s != 42) {
            LOGGER.error("Error: invalid tiff identifier");
            return false;
        }
        return true;
    }

    private int readIFD(int n, int n2) throws IOException {
        IFD iFD = new IFD();
        LOGGER.info("IFD {} offset: byte {}", (Object)n, (Object)n2);
        this.randIS.seek(n2);
        int n3 = this.randIS.readShort();
        LOGGER.info("Total number of fields for IFD {}: {}", (Object)n, (Object)n3);
        n2 += 2;
        block9: for (int i = 0; i < n3; ++i) {
            LOGGER.info("TiffField {} =>", (Object)i);
            this.randIS.seek(n2);
            short s = this.randIS.readShort();
            Tag tag = TiffTag.fromShort(s);
            if (tag == TiffTag.UNKNOWN) {
                LOGGER.info("TiffTag: {} [Value: 0x{}] (Unknown)", (Object)tag, (Object)Integer.toHexString(s & 0xFFFF));
            } else {
                LOGGER.info("TiffTag: {}", (Object)tag);
            }
            this.randIS.seek(n2 += 2);
            short s2 = this.randIS.readShort();
            FieldType fieldType = FieldType.fromShort(s2);
            LOGGER.info("Data type: {}", (Object)fieldType);
            this.randIS.seek(n2 += 2);
            int n4 = this.randIS.readInt();
            LOGGER.info("TiffField length: {}", (Object)n4);
            n2 += 4;
            switch (fieldType) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] byArray = new byte[n4];
                    if (n4 <= 4) {
                        this.randIS.seek(n2);
                        this.randIS.readFully(byArray, 0, n4);
                    } else {
                        this.randIS.seek(n2);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(byArray, 0, n4);
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.byteArrayToHexString(byArray, 0, 10));
                    n2 += 4;
                    iFD.addField(fieldType == FieldType.BYTE ? new ByteField(s, byArray) : new UndefinedField(s, byArray));
                    continue block9;
                }
                case ASCII: {
                    byte[] byArray = new byte[n4];
                    if (n4 <= 4) {
                        this.randIS.seek(n2);
                        this.randIS.readFully(byArray, 0, n4);
                    } else {
                        this.randIS.seek(n2);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(byArray, 0, n4);
                    }
                    if (byArray.length > 0) {
                        LOGGER.info("TiffField value: {}", (Object)new String(byArray, 0, byArray.length - 1).trim());
                    }
                    n2 += 4;
                    iFD.addField(new ASCIIField(s, new String(byArray, 0, byArray.length)));
                    continue block9;
                }
                case SHORT: {
                    int n5;
                    short[] sArray = new short[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        sArray[0] = this.randIS.readShort();
                        n2 += 4;
                    } else if (n4 == 2) {
                        this.randIS.seek(n2);
                        sArray[0] = this.randIS.readShort();
                        this.randIS.seek(n2 += 2);
                        sArray[1] = this.randIS.readShort();
                        n2 += 2;
                    } else {
                        this.randIS.seek(n2);
                        int n6 = this.randIS.readInt();
                        n2 += 4;
                        for (n5 = 0; n5 < n4; ++n5) {
                            this.randIS.seek(n6);
                            sArray[n5] = this.randIS.readShort();
                            n6 += 2;
                        }
                    }
                    iFD.addField(new ShortField(s, sArray));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.shortArrayToString(sArray, 0, 10, true));
                    continue block9;
                }
                case LONG: {
                    int n7;
                    int n5;
                    int[] nArray = new int[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        nArray[0] = this.randIS.readInt();
                        n2 += 4;
                    } else {
                        this.randIS.seek(n2);
                        n5 = this.randIS.readInt();
                        n2 += 4;
                        for (n7 = 0; n7 < n4; ++n7) {
                            this.randIS.seek(n5);
                            nArray[n7] = this.randIS.readInt();
                            n5 += 4;
                        }
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.longArrayToString(nArray, 0, 10, true));
                    iFD.addField(new LongField(s, nArray));
                    continue block9;
                }
                case RATIONAL: {
                    int n5 = 2 * n4;
                    int[] nArray = new int[n5];
                    this.randIS.seek(n2);
                    int n7 = this.randIS.readInt();
                    n2 += 4;
                    for (int j = 0; j < n5; j += 2) {
                        this.randIS.seek(n7);
                        nArray[j] = this.randIS.readInt();
                        this.randIS.seek(n7 += 4);
                        nArray[j + 1] = this.randIS.readInt();
                        n7 += 4;
                    }
                    iFD.addField(new RationalField(s, nArray));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.rationalArrayToString(nArray, true));
                    continue block9;
                }
                case FLOAT: {
                    int n7;
                    float[] fArray = new float[n4];
                    if (n4 == 1) {
                        this.randIS.seek(n2);
                        fArray[0] = this.randIS.readFloat();
                        n2 += 4;
                    } else {
                        this.randIS.seek(n2);
                        n7 = this.randIS.readInt();
                        n2 += 4;
                        for (int j = 0; j < n4; ++j) {
                            this.randIS.seek(n7);
                            fArray[j] = this.randIS.readFloat();
                            n7 += 4;
                        }
                    }
                    iFD.addField(new FloatField(s, fArray));
                    LOGGER.info("TiffField value: {}", (Object)Arrays.toString(fArray));
                    continue block9;
                }
                case DOUBLE: {
                    double[] dArray = new double[n4];
                    this.randIS.seek(n2);
                    int n7 = this.randIS.readInt();
                    n2 += 4;
                    for (int j = 0; j < n4; ++j) {
                        this.randIS.seek(n7);
                        dArray[j] = this.randIS.readDouble();
                        n7 += 8;
                    }
                    iFD.addField(new DoubleField(s, dArray));
                    LOGGER.info("Field value: {}", (Object)Arrays.toString(dArray));
                    continue block9;
                }
                default: {
                    n2 += 4;
                }
            }
        }
        this.ifds.add(iFD);
        LOGGER.info("********************************");
        this.randIS.seek(n2);
        return this.randIS.readInt();
    }

    protected boolean readIFDs(InputStream inputStream) throws Exception {
        this.randIS = new FileCacheRandomAccessInputStream(inputStream, 40960);
        if (!this.readHeader(this.randIS)) {
            return false;
        }
        this.ifds = new ArrayList<IFD>();
        int n = this.randIS.readInt();
        int n2 = 0;
        while (n != 0) {
            try {
                n = this.readIFD(n2++, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        return true;
    }

    private static byte[] applyDePredictor(int n, byte[] byArray, int n2, int n3) {
        int n4 = n * n2;
        int n5 = n4 - n;
        int n6 = n;
        for (int i = 0; i <= n3 - 1; ++i) {
            for (int j = n6; j <= n5; j += n) {
                for (int k = 0; k < n; ++k) {
                    int n7 = j + k;
                    byArray[n7] = (byte)(byArray[n7] + byArray[j - n + k]);
                }
            }
            n5 += n4;
            n6 += n4;
        }
        return byArray;
    }

    private static short[] applyDePredictor(int n, short[] sArray, int n2, int n3) {
        int n4 = n * n2;
        int n5 = n4 - n;
        int n6 = n;
        for (int i = 0; i <= n3 - 1; ++i) {
            for (int j = n6; j <= n5; j += n) {
                for (int k = 0; k < n; ++k) {
                    int n7 = j + k;
                    sArray[n7] = (short)(sArray[n7] + sArray[j - n + k]);
                }
            }
            n5 += n4;
            n6 += n4;
        }
        return sArray;
    }

    private static byte[] applyDePredictor2(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n4 - 1;
        int n6 = n + 1;
        for (int i = n3 - 1; i >= 0; --i) {
            for (int j = n6; j < n5; ++j) {
                int n7 = j;
                byArray[n7] = (byte)(byArray[n7] + byArray[j - 1]);
            }
            n5 += n4;
            n6 += n4;
        }
        return byArray;
    }

    private void unpackStrip(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        this.randIS.seek(n3);
        byte[] byArray2 = null;
        if (n4 == 0) {
            byArray2 = IOUtils.readFully((InputStream)this.randIS, 4096);
        } else {
            byArray2 = new byte[n4];
            this.randIS.readFully(byArray2);
        }
        byte[] byArray3 = new byte[n2];
        Packbits.unpackbits(byArray2, byArray3);
        System.arraycopy(byArray3, 0, byArray, n, n2);
    }

    private int upsampling(int n, int n2, int n3, int[] nArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, byte[] byArray, byte[] byArray2, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n8 = n6 + n3;
            int n9 = byArray[n8] & 0xFF;
            int n10 = byArray[n8 + 1] & 0xFF;
            for (int j = 0; j < nArray[1]; ++j) {
                int n11 = 0;
                while (n11 < nArray[0]) {
                    int n12 = byArray[n6++] & 0xFF;
                    float f12 = ((float)n12 - f) * f7 / (f2 - f);
                    float f13 = ((float)n9 - f3) * f8 / (f4 - f3);
                    float f14 = ((float)n10 - f5) * f8 / (f6 - f5);
                    float f15 = f14 * (2.0f - 2.0f * f9) + f12;
                    float f16 = f13 * (2.0f - 2.0f * f11) + f12;
                    float f17 = (f12 - f11 * f16 - f9 * f15) / f10;
                    if (f15 < 0.0f) {
                        f15 = 0.0f;
                    }
                    if (f15 > 255.0f) {
                        f15 = 255.0f;
                    }
                    if (f17 < 0.0f) {
                        f17 = 0.0f;
                    }
                    if (f17 > 255.0f) {
                        f17 = 255.0f;
                    }
                    if (f16 < 0.0f) {
                        f16 = 0.0f;
                    }
                    if (f16 > 255.0f) {
                        f16 = 255.0f;
                    }
                    int n13 = n7 + n * n4;
                    int n14 = 3 * n13;
                    byArray2[n14] = (byte)f15;
                    byArray2[n14 + 1] = (byte)f17;
                    byArray2[n14 + 2] = (byte)f16;
                    ++n11;
                    ++n7;
                }
                n7 -= nArray[0];
                ++n;
            }
            n -= nArray[1];
            n6 += 2;
            n7 += nArray[0];
            if (i % n5 != 0) continue;
            n += nArray[1];
            n7 = 0;
        }
        return n;
    }

    static {
        int n;
        redMask = new int[]{0, 4, 48, 448, 3840};
        greenMask = new int[]{0, 2, 12, 56, 240};
        blueMask = new int[]{0, 1, 3, 7, 15};
        BLACK_WHITE_PALETTE = new int[]{-16777216, -1};
        BLACK_WHITE_PALETTE_WHITE_IS_ZERO = new int[]{-1, -16777216};
        FOUR_COLOR_PALETTE = new int[]{-16777216, -12566464, -8355712, -1};
        FOUR_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -8355712, -12566464, -16777216};
        SIXTEEN_COLOR_PALETTE = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
        SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -1118482, -2236963, -3355444, -4473925, -5592406, -6710887, -7829368, -8947849, -10066330, -11184811, -12303292, -13421773, -14540254, -15658735, -16777216};
        EIGHT_BIT_COLOR_PALETTE = new int[256];
        EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO = new int[256];
        GROUP3OPT_2DENCODING = 1;
        GROUP3OPT_UNCOMPRESSED = 2;
        for (n = 0; n < 256; ++n) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE[n] = 0xFF000000 | n << 16 | n << 8 | n & 0xFF;
        }
        for (n = 0; n < 256; ++n) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO[255 - n] = 0xFF000000 | n << 16 | n << 8 | n & 0xFF;
        }
        LOGGER = LoggerFactory.getLogger(TIFFReader.class);
    }
}

