/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.compression.UnsupportedCompressionException;
import com.icafe4j.image.compression.huffman.HuffmanTbl;
import com.icafe4j.image.jpeg.Component;
import com.icafe4j.image.jpeg.DHTReader;
import com.icafe4j.image.jpeg.DQTReader;
import com.icafe4j.image.jpeg.HTable;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.jpeg.QTable;
import com.icafe4j.image.jpeg.SOFReader;
import com.icafe4j.image.jpeg.SOSReader;
import com.icafe4j.image.jpeg.Segment;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.adobe.IRB;
import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.image.meta.icc.ICCProfile;
import com.icafe4j.image.meta.iptc.IPTC;
import com.icafe4j.image.meta.jpeg.JpegExif;
import com.icafe4j.image.meta.jpeg.JpegXMP;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import com.icafe4j.string.XMLUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPGReader
extends ImageReader {
    private Map<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
    private ByteArrayOutputStream iccProfileStream = null;
    private ByteArrayOutputStream eightBIMStream = null;
    private byte[] extendedXMP = null;
    private String xmpGUID = "";
    private int[][] quant_tbl = new int[4][];
    private HuffmanTbl[] dc_hufftbl = new HuffmanTbl[4];
    private HuffmanTbl[] ac_hufftbl = new HuffmanTbl[4];
    private Map<Integer, Component> components = new HashMap<Integer, Component>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGReader.class);

    public BufferedImage read1(InputStream inputStream) throws Exception {
        XMP xMP;
        Object object;
        boolean bl = false;
        int n = 0;
        ArrayList<SOFReader> arrayList = new ArrayList<SOFReader>();
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        short s = IOUtils.readShortMM(inputStream);
        block13: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case PADDING: {
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                    }
                    s = (short)(0xFF00 | n2);
                    continue block13;
                }
                case DQT: {
                    this.read_DQT(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case DHT: {
                    this.read_DHT(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case SOS: {
                    object = (SOFReader)arrayList.get(arrayList.size() - 1);
                    s = this.readSOS(inputStream, (SOFReader)object);
                    continue block13;
                }
                case SOF0: 
                case SOF1: 
                case SOF2: {
                    arrayList.add(this.readSOF(inputStream, marker));
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case SOF3: 
                case SOF5: 
                case SOF6: 
                case SOF7: 
                case SOF9: 
                case SOF10: 
                case SOF11: 
                case SOF13: 
                case SOF14: 
                case SOF15: {
                    throw new UnsupportedCompressionException(marker.getDescription() + " is not supported by this decoder!");
                }
                case APP1: {
                    this.readAPP1(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case APP2: {
                    this.readAPP2(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case APP13: {
                    this.readAPP13(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
                case APP14: {
                    this.readAPP14(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block13;
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            s = IOUtils.readShortMM(inputStream);
        }
        if (this.extendedXMP != null && (xMP = (XMP)this.metadataMap.get((Object)MetadataType.XMP)) != null) {
            xMP.setExtendedXMPData(this.extendedXMP);
        }
        if (this.iccProfileStream != null) {
            ICCProfile iCCProfile = new ICCProfile(this.iccProfileStream.toByteArray());
            this.metadataMap.put(MetadataType.ICC_PROFILE, iCCProfile);
        }
        if (this.eightBIMStream != null) {
            IRB iRB = new IRB(this.eightBIMStream.toByteArray());
            this.metadataMap.put(MetadataType.PHOTOSHOP_IRB, iRB);
            object = iRB.get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (object != null) {
                this.metadataMap.put(MetadataType.IPTC, new IPTC(((_8BIM)object).getData()));
            }
        }
        return null;
    }

    private void readAPP1(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray;
        int n2 = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray2 = new byte[n2 - 2];
        IOUtils.readFully(inputStream, byArray2);
        if (byArray2.length >= "Exif\u0000\u0000".length() && new String(byArray2, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
            JpegExif jpegExif = new JpegExif(ArrayUtils.subArray(byArray2, "Exif\u0000\u0000".length(), n2 - "Exif\u0000\u0000".length() - 2));
            this.metadataMap.put(MetadataType.EXIF, jpegExif);
        } else if (byArray2.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray2, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || byArray2.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray2, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000")) {
            JpegXMP jpegXMP = new JpegXMP(ArrayUtils.subArray(byArray2, "http://ns.adobe.com/xap/1.0/\u0000".length(), n2 - "http://ns.adobe.com/xap/1.0/\u0000".length() - 2));
            this.metadataMap.put(MetadataType.XMP, jpegXMP);
            this.xmpGUID = XMLUtils.getAttribute(jpegXMP.getXmpDocument(), "rdf:Description", "xmpNote:HasExtendedXMP");
        } else if (byArray2.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(byArray2, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") && Arrays.equals(byArray = ArrayUtils.subArray(byArray2, n = "http://ns.adobe.com/xmp/extension/\u0000".length(), 32), this.xmpGUID.getBytes())) {
            long l = IOUtils.readUnsignedIntMM(byArray2, n += 32);
            n += 4;
            if (this.extendedXMP == null) {
                this.extendedXMP = new byte[(int)l];
            }
            long l2 = IOUtils.readUnsignedIntMM(byArray2, n);
            byte[] byArray3 = ArrayUtils.subArray(byArray2, n += 4, n2 - "http://ns.adobe.com/xmp/extension/\u0000".length() - 42);
            System.arraycopy(byArray3, 0, this.extendedXMP, (int)l2, byArray3.length);
        }
    }

    private void readAPP2(InputStream inputStream) throws IOException {
        int n = "ICC_PROFILE\u0000".length();
        byte[] byArray = new byte[n];
        int n2 = IOUtils.readUnsignedShortMM(inputStream);
        IOUtils.readFully(inputStream, byArray);
        if (Arrays.equals(byArray, "ICC_PROFILE\u0000".getBytes())) {
            byArray = new byte[n2 - n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (this.iccProfileStream == null) {
                this.iccProfileStream = new ByteArrayOutputStream();
            }
            this.iccProfileStream.write(ArrayUtils.subArray(byArray, 2, n2 - n - 4));
        } else {
            IOUtils.skipFully(inputStream, n2 - n - 2);
        }
    }

    private void readAPP13(InputStream inputStream) throws IOException {
        int n = "Photoshop 3.0\u0000".length();
        byte[] byArray = new byte[n];
        int n2 = IOUtils.readUnsignedShortMM(inputStream);
        IOUtils.readFully(inputStream, byArray);
        if (Arrays.equals(byArray, "Photoshop 3.0\u0000".getBytes())) {
            byArray = new byte[n2 - n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (this.eightBIMStream == null) {
                this.eightBIMStream = new ByteArrayOutputStream();
            }
            this.eightBIMStream.write(byArray);
        } else {
            IOUtils.skipFully(inputStream, n2 - n - 2);
        }
    }

    private void readAPP14(InputStream inputStream) throws IOException {
        String[] stringArray = new String[]{"DCTEncodeVersion: ", "APP14Flags0: ", "APP14Flags1: ", "ColorTransform: "};
        int n = 14;
        int n2 = IOUtils.readUnsignedShortMM(inputStream);
        if (n2 >= n) {
            byte[] byArray = new byte[n2 - 2];
            IOUtils.readFully(inputStream, byArray, 0, n2 - 2);
            byte[] byArray2 = ArrayUtils.subArray(byArray, 0, 5);
            if (Arrays.equals(byArray2, "Adobe".getBytes())) {
                int n3 = 0;
                int n4 = 5;
                while (n3 < 3) {
                    LOGGER.info("{}{}", (Object)stringArray[n3], (Object)StringUtils.shortToHexStringMM(IOUtils.readShortMM(byArray, n4)));
                    ++n3;
                    n4 += 2;
                }
                LOGGER.debug("{}{}", (Object)stringArray[3], (Object)((byArray[11] & 0xFF) == 0 ? "Unknown (RGB or CMYK)" : ((byArray[11] & 0xFF) == 1 ? "YCbCr" : "YCCK")));
            }
        }
    }

    private void read_DQT(InputStream inputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DQTReader dQTReader = new DQTReader(new Segment(Marker.DQT, n, byArray));
        List<QTable> list = dQTReader.getTables();
        for (QTable qTable : list) {
            int n2 = qTable.getID();
            this.quant_tbl[n2] = qTable.getData();
        }
        LOGGER.debug("\n{}", (Object)JPGReader.qTablesToString(list));
    }

    private static String qTablesToString(List<QTable> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quantization table information =>:\n");
        int n = 0;
        for (QTable qTable : list) {
            int n2;
            int n3 = qTable.getPrecision();
            int[] nArray = qTable.getData();
            stringBuilder.append("precision of QT is " + n3 + "\n");
            stringBuilder.append("Quantization table #" + qTable.getID() + ":\n");
            if (n3 == 0) {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            } else {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            }
            ++n;
            stringBuilder.append("\n");
            stringBuilder.append("***************************\n");
        }
        stringBuilder.append("Total number of Quantation tables: " + n + "\n");
        stringBuilder.append("End of quantization table information\n");
        return stringBuilder.toString();
    }

    private void read_DHT(InputStream inputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DHTReader dHTReader = new DHTReader(new Segment(Marker.DHT, n, byArray));
        List<HTable> list = dHTReader.getDCTables();
        List<HTable> list2 = dHTReader.getACTables();
        for (HTable hTable : list) {
            this.dc_hufftbl[hTable.getID()] = new HuffmanTbl(hTable.getBits(), hTable.getValues());
        }
        for (HTable hTable : list2) {
            this.ac_hufftbl[hTable.getID()] = new HuffmanTbl(hTable.getBits(), hTable.getValues());
        }
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(list));
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(list2));
    }

    private static String hTablesToString(List<HTable> list) {
        String[] stringArray = new String[]{"DC Component", "AC Component"};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Huffman table information =>:\n");
        for (HTable hTable : list) {
            int n;
            stringBuilder.append("Class: " + hTable.getClazz() + " (" + stringArray[hTable.getClazz()] + ")\n");
            stringBuilder.append("Huffman table #: " + hTable.getID() + "\n");
            byte[] byArray = hTable.getBits();
            byte[] byArray2 = hTable.getValues();
            int n2 = 0;
            for (n = 0; n < byArray.length; ++n) {
                n2 += byArray[n] & 0xFF;
            }
            stringBuilder.append("Number of codes: " + n2 + "\n");
            if (n2 > 256) {
                throw new RuntimeException("Invalid huffman code count: " + n2);
            }
            n = 0;
            for (int i = 0; i < 16; ++i) {
                stringBuilder.append("Codes of length " + (i + 1) + " (" + (byArray[i] & 0xFF) + " total): [ ");
                for (int j = 0; j < (byArray[i] & 0xFF); ++j) {
                    stringBuilder.append((byArray2[n++] & 0xFF) + " ");
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("<= End of Huffman table information>>\n");
        }
        return stringBuilder.toString();
    }

    private SOFReader readSOF(InputStream inputStream, Marker marker) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(marker, n, byArray);
        SOFReader sOFReader = new SOFReader(segment);
        LOGGER.debug("\n{}", (Object)JPGReader.sofToString(sOFReader));
        return sOFReader;
    }

    private static String sofToString(SOFReader sOFReader) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOF information =>\n");
        stringBuilder.append("Precision: " + sOFReader.getPrecision() + "\n");
        stringBuilder.append("Image height: " + sOFReader.getFrameHeight() + "\n");
        stringBuilder.append("Image width: " + sOFReader.getFrameWidth() + "\n");
        stringBuilder.append("# of Components: " + sOFReader.getNumOfComponents() + "\n");
        stringBuilder.append("(1 = grey scaled, 3 = color YCbCr or YIQ, 4 = color CMYK)\n");
        for (Component component : sOFReader.getComponents()) {
            stringBuilder.append("\n");
            stringBuilder.append("Component ID: " + component.getId() + "\n");
            stringBuilder.append("Herizontal sampling factor: " + component.getHSampleFactor() + "\n");
            stringBuilder.append("Vertical sampling factor: " + component.getVSampleFactor() + "\n");
            stringBuilder.append("Quantization table #: " + component.getQTableNumber() + "\n");
            stringBuilder.append("DC table number: " + component.getDCTableNumber() + "\n");
            stringBuilder.append("AC table number: " + component.getACTableNumber() + "\n");
        }
        stringBuilder.append("<= End of SOF information\n");
        return stringBuilder.toString();
    }

    private short readSOS(InputStream inputStream, SOFReader sOFReader) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(Marker.SOS, n, byArray);
        new SOSReader(segment, sOFReader);
        int n2 = 0;
        short s = 0;
        block3: while ((n2 = IOUtils.read(inputStream)) != -1) {
            if (n2 != 255) continue;
            n2 = IOUtils.read(inputStream);
            if (n2 == -1) {
                return Marker.EOI.getValue();
            }
            if (n2 == 0) continue;
            s = (short)(0xFF00 | n2);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n2 == -1) {
            return Marker.EOI.getValue();
        }
        if (Marker.fromShort(s) == Marker.UNKNOWN) {
            return Marker.EOI.getValue();
        }
        return s;
    }

    public Map<MetadataType, Metadata> getMetadata() {
        return this.metadataMap;
    }

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        return ImageIO.read(inputStream);
    }
}

