/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkBuilder;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Builder;
import java.util.Calendar;

public class TIMEBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    public TIMEBuilder() {
        super(ChunkType.TIME);
    }

    public TIMEBuilder calendar(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        return this;
    }

    public TIMEBuilder year(int n) {
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Year out of range: -32768 - 32767");
        }
        this.year = n;
        return this;
    }

    public TIMEBuilder month(int n) {
        if (n > 12 || n < 1) {
            throw new IllegalArgumentException("Month out of range: 1-12");
        }
        this.month = n;
        return this;
    }

    public TIMEBuilder day(int n) {
        if (n > 31 || n < 1) {
            throw new IllegalArgumentException("Day out of range: 1-31");
        }
        this.day = n;
        return this;
    }

    public TIMEBuilder hour(int n) {
        if (n > 23 || n < 0) {
            throw new IllegalArgumentException("Hour out of range: 0-23");
        }
        this.hour = n;
        return this;
    }

    public TIMEBuilder minute(int n) {
        if (n > 59 || n < 0) {
            throw new IllegalArgumentException("Minute out of range: 0-59");
        }
        this.minute = n;
        return this;
    }

    public TIMEBuilder second(int n) {
        if (n > 60 || n < 0) {
            throw new IllegalArgumentException("Second out of range: 0-60");
        }
        this.second = n;
        return this;
    }

    @Override
    protected byte[] buildData() {
        return new byte[]{(byte)(this.year >>> 8), (byte)this.year, (byte)this.month, (byte)this.day, (byte)this.hour, (byte)this.minute, (byte)this.second};
    }
}

