/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkBuilder;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.ColorType;
import com.icafe4j.util.Builder;

public class IHDRBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private int width = 0;
    private int height = 0;
    private int bitDepth = 0;
    private int colorType = 0;
    private int compressionMethod = 0;
    private int filterMethod = 0;
    private int interlaceMethod = 0;

    public IHDRBuilder width(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid width: " + n);
        }
        this.width = n;
        return this;
    }

    public IHDRBuilder height(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid height: " + n);
        }
        this.height = n;
        return this;
    }

    public IHDRBuilder bitDepth(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.bitDepth = n;
                return this;
            }
        }
        throw new IllegalArgumentException("Invalid bitDepth: " + n);
    }

    public IHDRBuilder colorType(ColorType colorType) {
        switch (colorType) {
            case GRAY_SCALE: 
            case TRUE_COLOR: 
            case INDEX_COLOR: 
            case GRAY_SCALE_WITH_ALPHA: 
            case TRUE_COLOR_WITH_ALPHA: {
                this.colorType = colorType.getValue();
                return this;
            }
        }
        throw new IllegalArgumentException("Invalid colorType: " + (Object)((Object)colorType));
    }

    public IHDRBuilder compressionMethod(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Invalid comressionMethod" + n);
        }
        this.compressionMethod = n;
        return this;
    }

    public IHDRBuilder filterMethod(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Invalid filterMethod: " + n);
        }
        this.filterMethod = n;
        return this;
    }

    public IHDRBuilder interlaceMethod(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid interlaceMethod" + n);
        }
        this.interlaceMethod = n;
        return this;
    }

    public IHDRBuilder() {
        super(ChunkType.IHDR);
    }

    @Override
    protected byte[] buildData() {
        byte[] byArray = new byte[]{(byte)(this.width >>> 24), (byte)(this.width >>> 16), (byte)(this.width >>> 8), (byte)this.width, (byte)(this.height >>> 24), (byte)(this.height >>> 16), (byte)(this.height >>> 8), (byte)this.height, (byte)this.bitDepth, (byte)this.colorType, (byte)this.compressionMethod, (byte)this.filterMethod, (byte)this.interlaceMethod};
        return byArray;
    }
}

