/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.jpeg;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.jpeg.JFIFThumbnail;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class JFIF
extends Metadata {
    private int majorVersion;
    private int minorVersion;
    private int densityUnit;
    private int xDensity;
    private int yDensity;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private boolean containsThumbnail;
    private JFIFThumbnail thumbnail;

    private static void checkInput(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Invalid major version number: " + n);
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("Invalid minor version number: " + n2);
        }
        if (n3 < 0 || n3 > 2) {
            throw new IllegalArgumentException("Density unit value " + n3 + " out of range [0-2]");
        }
        if (n4 < 0 || n4 > 65535) {
            throw new IllegalArgumentException("xDensity value " + n4 + " out of range (0-0xffff]");
        }
        if (n5 < 0 || n5 > 65535) {
            throw new IllegalArgumentException("yDensity value " + n4 + " out of range (0-0xffff]");
        }
    }

    public JFIF(byte[] byArray) {
        super(MetadataType.JPG_JFIF, byArray);
        this.ensureDataRead();
    }

    public JFIF(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, null);
    }

    public JFIF(int n, int n2, int n3, int n4, int n5, JFIFThumbnail jFIFThumbnail) {
        super(MetadataType.JPG_JFIF);
        JFIF.checkInput(n, n2, n3, n4, n5);
        this.majorVersion = n;
        this.minorVersion = n2;
        this.densityUnit = n3;
        this.xDensity = n4;
        this.yDensity = n5;
        if (jFIFThumbnail != null) {
            int n6 = jFIFThumbnail.getWidth();
            int n7 = jFIFThumbnail.getHeight();
            if (n6 < 0 || n6 > 255) {
                throw new IllegalArgumentException("Thumbnail width " + n6 + " out of range (0-0xff]");
            }
            if (n7 < 0 || n7 > 255) {
                throw new IllegalArgumentException("Thumbnail height " + n7 + " out of range (0-0xff]");
            }
            this.thumbnailWidth = n6;
            this.thumbnailHeight = n7;
            this.thumbnail = jFIFThumbnail;
            this.containsThumbnail = true;
        }
        this.isDataRead = true;
    }

    public boolean containsThumbnail() {
        return this.containsThumbnail;
    }

    public int getDensityUnit() {
        return this.densityUnit;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public JFIFThumbnail getThumbnail() {
        return new JFIFThumbnail(this.thumbnail);
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getXDensity() {
        return this.xDensity;
    }

    public int getYDensity() {
        return this.yDensity;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        String[] stringArray = new String[]{"No units, aspect ratio only specified", "Dots per inch", "Dots per centimeter"};
        arrayList.add(new MetadataEntry("Version", this.majorVersion + "." + this.minorVersion));
        arrayList.add(new MetadataEntry("Density unit", this.densityUnit <= 2 ? stringArray[this.densityUnit] : this.densityUnit + ""));
        arrayList.add(new MetadataEntry("XDensity", this.xDensity + ""));
        arrayList.add(new MetadataEntry("YDensity", this.yDensity + ""));
        arrayList.add(new MetadataEntry("Thumbnail width", this.thumbnailWidth + ""));
        arrayList.add(new MetadataEntry("Thumbnail height", this.thumbnailHeight + ""));
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 9;
            int n2 = 0;
            if (this.data.length >= n) {
                this.majorVersion = this.data[n2++] & 0xFF;
                this.minorVersion = this.data[n2++] & 0xFF;
                this.densityUnit = this.data[n2++] & 0xFF;
                this.xDensity = IOUtils.readUnsignedShortMM(this.data, n2);
                this.yDensity = IOUtils.readUnsignedShortMM(this.data, n2 += 2);
                n2 += 2;
                this.thumbnailWidth = this.data[n2++] & 0xFF;
                this.thumbnailHeight = this.data[n2] & 0xFF;
                if (this.thumbnailWidth != 0 && this.thumbnailHeight != 0) {
                    this.containsThumbnail = true;
                    int n3 = 3 * this.thumbnailWidth * this.thumbnailHeight;
                    DataBufferByte dataBufferByte = new DataBufferByte(ArrayUtils.subArray(this.data, n, n3), n3);
                    int[] nArray = new int[]{0, 1, 2};
                    int n4 = 3;
                    WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.thumbnailWidth, this.thumbnailHeight, 3 * this.thumbnailWidth, n4, nArray, null);
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                    this.thumbnail = new JFIFThumbnail(new BufferedImage(componentColorModel, writableRaster, false, null));
                }
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.ensureDataRead();
        IOUtils.write(outputStream, this.majorVersion);
        IOUtils.write(outputStream, this.minorVersion);
        IOUtils.write(outputStream, this.densityUnit);
        IOUtils.writeShortMM(outputStream, this.getXDensity());
        IOUtils.writeShortMM(outputStream, this.getYDensity());
        IOUtils.write(outputStream, this.thumbnailWidth);
        IOUtils.write(outputStream, this.thumbnailHeight);
        if (this.containsThumbnail) {
            this.thumbnail.write(outputStream);
        }
    }
}

