/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.iptc.IPTCApplicationTag;
import com.icafe4j.image.meta.iptc.IPTCEnvelopeTag;
import com.icafe4j.image.meta.iptc.IPTCFotoStationTag;
import com.icafe4j.image.meta.iptc.IPTCNewsPhotoTag;
import com.icafe4j.image.meta.iptc.IPTCObjectDataTag;
import com.icafe4j.image.meta.iptc.IPTCPostObjectDataTag;
import com.icafe4j.image.meta.iptc.IPTCPreObjectDataTag;
import com.icafe4j.image.meta.iptc.IPTCRecord;
import com.icafe4j.image.meta.iptc.IPTCTag;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class IPTCDataSet
implements Comparable<IPTCDataSet> {
    private int recordNumber;
    private int tag;
    private int size;
    private byte[] data;
    private int offset;
    private IPTCTag tagEnum;
    private String name;

    private static final byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public IPTCDataSet(int n, byte[] byArray) {
        this(IPTCRecord.APPLICATION, n, byArray);
    }

    public IPTCDataSet(int n, int n2, int n3, byte[] byArray, int n4) {
        this.recordNumber = n;
        this.tag = n2;
        this.size = n3;
        this.data = byArray;
        this.offset = n4;
        this.name = this.getTagName();
    }

    public IPTCDataSet(int n, String string) {
        this(n, IPTCDataSet.getBytes(string));
    }

    public IPTCDataSet(IPTCApplicationTag iPTCApplicationTag, byte[] byArray) {
        this(iPTCApplicationTag.getTag(), byArray);
    }

    public IPTCDataSet(IPTCApplicationTag iPTCApplicationTag, String string) {
        this(iPTCApplicationTag.getTag(), string);
    }

    public IPTCDataSet(IPTCRecord iPTCRecord, int n, byte[] byArray) {
        this(iPTCRecord.getRecordNumber(), n, byArray.length, byArray, 0);
    }

    public IPTCDataSet(IPTCRecord iPTCRecord, int n, String string) {
        this(iPTCRecord, n, IPTCDataSet.getBytes(string));
    }

    public boolean allowMultiple() {
        return this.tagEnum.allowMultiple();
    }

    @Override
    public int compareTo(IPTCDataSet iPTCDataSet) {
        if (this == iPTCDataSet) {
            return 0;
        }
        if (this.getRecordNumber() < iPTCDataSet.getRecordNumber()) {
            return -1;
        }
        if (this.getRecordNumber() > iPTCDataSet.getRecordNumber()) {
            return 1;
        }
        if (this.getRecordNumber() == iPTCDataSet.getRecordNumber()) {
            if (this.getTag() < iPTCDataSet.getTag()) {
                return -1;
            }
            if (this.getTag() > iPTCDataSet.getTag()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IPTCDataSet iPTCDataSet = (IPTCDataSet)object;
        byte[] byArray2 = ArrayUtils.subArray(this.data, this.offset, this.size);
        if (!Arrays.equals(byArray2, byArray = ArrayUtils.subArray(iPTCDataSet.data, iPTCDataSet.offset, iPTCDataSet.size))) {
            return false;
        }
        if (this.recordNumber != iPTCDataSet.recordNumber) {
            return false;
        }
        return this.tag == iPTCDataSet.tag;
    }

    public byte[] getData() {
        return ArrayUtils.subArray(this.data, this.offset, this.size);
    }

    public String getDataAsString() {
        return this.tagEnum.getDataAsString(this.getData());
    }

    public String getName() {
        return this.name;
    }

    public String getRecordType() {
        switch (this.recordNumber) {
            case 1: {
                return "Envelope Record";
            }
            case 2: {
                return "Application Record";
            }
            case 3: {
                return "NewsPhoto Record";
            }
            case 7: {
                return "PreObjectData Record";
            }
            case 8: {
                return "ObjectData Record";
            }
            case 9: {
                return "PostObjectData Record";
            }
            case 240: {
                return "FotoStation Record";
            }
        }
        return "Unknown Record";
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getSize() {
        return this.size;
    }

    public int getTag() {
        return this.tag;
    }

    public IPTCTag getTagEnum() {
        return this.tagEnum;
    }

    private String getTagName() {
        block0 : switch (IPTCRecord.fromRecordNumber(this.recordNumber)) {
            case APPLICATION: {
                this.tagEnum = IPTCApplicationTag.fromTag(this.tag);
                break;
            }
            case ENVELOP: {
                this.tagEnum = IPTCEnvelopeTag.fromTag(this.tag);
                break;
            }
            case FOTOSTATION: {
                this.tagEnum = IPTCFotoStationTag.fromTag(this.tag);
                break;
            }
            case NEWSPHOTO: {
                this.tagEnum = IPTCNewsPhotoTag.fromTag(this.tag);
                break;
            }
            case OBJECTDATA: {
                this.tagEnum = IPTCObjectDataTag.fromTag(this.tag);
                break;
            }
            case POST_OBJECTDATA: {
                this.tagEnum = IPTCPostObjectDataTag.fromTag(this.tag);
                break;
            }
            case PRE_OBJECTDATA: {
                this.tagEnum = IPTCPreObjectDataTag.fromTag(this.tag);
                break;
            }
            case UNKNOWN: {
                switch (IPTCRecord.fromRecordNumber(this.recordNumber)) {
                    case APPLICATION: {
                        this.tagEnum = IPTCApplicationTag.UNKNOWN;
                        break block0;
                    }
                    case ENVELOP: {
                        this.tagEnum = IPTCEnvelopeTag.UNKNOWN;
                        break block0;
                    }
                    case NEWSPHOTO: {
                        this.tagEnum = IPTCNewsPhotoTag.UNKNOWN;
                        break block0;
                    }
                    case PRE_OBJECTDATA: {
                        this.tagEnum = IPTCPreObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case OBJECTDATA: {
                        this.tagEnum = IPTCObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case POST_OBJECTDATA: {
                        this.tagEnum = IPTCPostObjectDataTag.UNKNOWN;
                        break block0;
                    }
                    case FOTOSTATION: {
                        this.tagEnum = IPTCFotoStationTag.UNKNOWN;
                        break block0;
                    }
                    case UNKNOWN: {
                        throw new RuntimeException("Unknown IPTC record");
                    }
                }
            }
        }
        return this.tagEnum.getName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(ArrayUtils.subArray(this.data, this.offset, this.size));
        n = 31 * n + this.recordNumber;
        n = 31 * n + this.tag;
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(28);
        outputStream.write(this.recordNumber);
        outputStream.write(this.getTag());
        IOUtils.writeShortMM(outputStream, this.size);
        outputStream.write(this.data, this.offset, this.size);
    }
}

