/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.icc;

import com.icafe4j.image.meta.icc.ProfileTag;
import com.icafe4j.io.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileTagTable {
    private int tagCount;
    private Map<Integer, TagEntry> tagEntries = new HashMap<Integer, TagEntry>();

    public void addTagEntry(TagEntry tagEntry) {
        this.tagEntries.put(tagEntry.getProfileTag(), tagEntry);
    }

    public void read(byte[] byArray) {
        int n = 128;
        this.tagCount = IOUtils.readIntMM(byArray, n);
        n += 4;
        for (int i = 0; i < this.tagCount; ++i) {
            int n2 = IOUtils.readIntMM(byArray, n);
            ProfileTag profileTag = ProfileTag.fromInt(n2);
            int n3 = IOUtils.readIntMM(byArray, n += 4);
            int n4 = IOUtils.readIntMM(byArray, n += 4);
            n += 4;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            this.tagEntries.put(n2, new TagEntry(profileTag.getValue(), n3, n4, byArray2));
        }
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public TagEntry getTagEntry(ProfileTag profileTag) {
        return this.tagEntries.get(profileTag.getValue());
    }

    public List<TagEntry> getTagEntries() {
        return new ArrayList<TagEntry>(this.tagEntries.values());
    }

    public static class TagEntry
    implements Comparable<TagEntry> {
        private int profileTag;
        private int dataOffset;
        private int dataLength;
        private byte[] data;

        public TagEntry(int n, int n2, int n3, byte[] byArray) {
            this.profileTag = n;
            this.dataOffset = n2;
            this.dataLength = n3;
            this.data = byArray;
        }

        @Override
        public int compareTo(TagEntry tagEntry) {
            return (int)(((long)this.profileTag & 0xFFFFFFFFL) - ((long)tagEntry.profileTag & 0xFFFFFFFFL));
        }

        public int getProfileTag() {
            return this.profileTag;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

