/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.adobe.ColorSpaceID;
import com.icafe4j.image.meta.adobe.DDBEntry;
import com.icafe4j.image.meta.adobe.DataBlockType;
import com.icafe4j.io.ReadStrategy;
import java.util.Arrays;

public class UserMask
extends DDBEntry {
    private int colorSpaceId;
    private int[] colors = new int[4];
    private int opacity;
    private int flag;

    public UserMask(int n, byte[] byArray, ReadStrategy readStrategy) {
        super(DataBlockType.LMsk, n, byArray, readStrategy);
        this.read();
    }

    public int[] getColors() {
        return (int[])this.colors.clone();
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        MetadataEntry metadataEntry = new MetadataEntry(DataBlockType.LMsk.name(), DataBlockType.LMsk.getDescription(), true);
        metadataEntry.addEntry(new MetadataEntry("Size", this.getSize() + ""));
        metadataEntry.addEntry(new MetadataEntry("Color Space", this.getColorSpaceID().name()));
        metadataEntry.addEntry(new MetadataEntry("Color Values", Arrays.toString(this.colors)));
        metadataEntry.addEntry(new MetadataEntry("Opacity", this.opacity + ""));
        metadataEntry.addEntry(new MetadataEntry("Flag", this.flag + ""));
        return metadataEntry;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getColorSpace() {
        return this.colorSpaceId;
    }

    public ColorSpaceID getColorSpaceID() {
        return ColorSpaceID.fromInt(this.colorSpaceId);
    }

    private void read() {
        int n = 0;
        this.colorSpaceId = this.readStrategy.readShort(this.data, n);
        this.colors[0] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[1] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[2] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[3] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.opacity = this.readStrategy.readShort(this.data, n += 2);
        this.flag = this.data[n += 2] & 0xFF;
    }
}

