/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.adobe.DataBlockType;
import com.icafe4j.io.ReadStrategy;
import com.icafe4j.string.StringUtils;

public class DDBEntry {
    private int type;
    private int size;
    protected byte[] data;
    protected ReadStrategy readStrategy;

    public DDBEntry(DataBlockType dataBlockType, int n, byte[] byArray, ReadStrategy readStrategy) {
        this(dataBlockType.getValue(), n, byArray, readStrategy);
    }

    public DDBEntry(int n, int n2, byte[] byArray, ReadStrategy readStrategy) {
        this.type = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size is negative");
        }
        this.size = n2;
        this.data = byArray;
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStrategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public int getType() {
        return this.type;
    }

    public DataBlockType getTypeEnum() {
        return DataBlockType.fromInt(this.type);
    }

    protected MetadataEntry getMetadataEntry() {
        DataBlockType dataBlockType = DataBlockType.fromInt(this.type);
        if (dataBlockType == DataBlockType.UNKNOWN) {
            return new MetadataEntry("UNKNOWN [" + StringUtils.intToHexStringMM(this.type) + "]:", dataBlockType.getDescription());
        }
        return new MetadataEntry("" + (Object)((Object)dataBlockType), dataBlockType.getDescription());
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }
}

