/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.gif;

import java.awt.image.BufferedImage;

public class GIFFrame {
    private BufferedImage frame;
    private int leftPosition;
    private int topPosition;
    private int frameWidth;
    private int frameHeight;
    private int delay;
    private int disposalMethod = 0;
    private int userInputFlag = 0;
    private int transparencyFlag = 0;
    private int transparentColor = -1;
    public static final int DISPOSAL_UNSPECIFIED = 0;
    public static final int DISPOSAL_LEAVE_AS_IS = 1;
    public static final int DISPOSAL_RESTORE_TO_BACKGROUND = 2;
    public static final int DISPOSAL_RESTORE_TO_PREVIOUS = 3;
    public static final int DISPOSAL_TO_BE_DEFINED = 7;
    public static final int USER_INPUT_NONE = 0;
    public static final int USER_INPUT_EXPECTED = 1;
    public static final int TRANSPARENCY_INDEX_NONE = 0;
    public static final int TRANSPARENCY_INDEX_SET = 1;
    public static final int TRANSPARENCY_COLOR_NONE = -1;

    public GIFFrame(BufferedImage bufferedImage) {
        this(bufferedImage, 0, 0, 0, 0);
    }

    public GIFFrame(BufferedImage bufferedImage, int n) {
        this(bufferedImage, 0, 0, n, 0);
    }

    public GIFFrame(BufferedImage bufferedImage, int n, int n2) {
        this(bufferedImage, 0, 0, n, n2);
    }

    public GIFFrame(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        this(bufferedImage, n, n2, n3, n4, 0, 0, -1);
    }

    public GIFFrame(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Null input image");
        }
        if (n4 < 0 || n4 > 7) {
            throw new IllegalArgumentException("Invalid disposal method: " + n4);
        }
        if (n5 < 0 || n5 > 1) {
            throw new IllegalArgumentException("Invalid user input flag: " + n5);
        }
        if (n6 < 0 || n6 > 1) {
            throw new IllegalArgumentException("Invalid transparency flag: " + n6);
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative coordinates for frame top-left position");
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.frame = bufferedImage;
        this.leftPosition = n;
        this.topPosition = n2;
        this.delay = n3;
        this.disposalMethod = n4;
        this.userInputFlag = n5;
        this.transparencyFlag = n6;
        this.frameWidth = bufferedImage.getWidth();
        this.frameHeight = bufferedImage.getHeight();
        this.transparentColor = n7;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDisposalMethod() {
        return this.disposalMethod;
    }

    public BufferedImage getFrame() {
        return this.frame;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getLeftPosition() {
        return this.leftPosition;
    }

    public int getTopPosition() {
        return this.topPosition;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public int getTransparencyFlag() {
        return this.transparencyFlag;
    }

    public int getUserInputFlag() {
        return this.userInputFlag;
    }
}

