/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.huffman;

public class HuffmanTbl {
    private byte[] BITS;
    private byte[] HUFFVAL;
    private int[] HUFFSIZE = new int[257];
    private int[] HUFFCODE = new int[257];
    private int[] EHUFCO = new int[257];
    private int[] EHUFSI = new int[257];
    private int[] MAXCODE = new int[16];
    private int[] MINCODE = new int[16];
    private int[] VALPTR = new int[16];
    private int LASTK = 0;

    public HuffmanTbl() {
    }

    public HuffmanTbl(byte[] byArray, byte[] byArray2) {
        this.BITS = byArray;
        this.HUFFVAL = byArray2;
    }

    private void generate_code_table() {
        int n = 0;
        int n2 = 0;
        int n3 = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n++] = n2++;
            if (this.HUFFSIZE[n] == n3) continue;
            if (this.HUFFSIZE[n] == 0) break;
            do {
                n2 <<= 1;
            } while (this.HUFFSIZE[n] != ++n3);
        }
    }

    private void generate_decoder_tables() {
        int n = -1;
        int n2 = 0;
        while (++n <= 15) {
            if (this.BITS[n] == 0) {
                this.MAXCODE[n] = -1;
                continue;
            }
            this.VALPTR[n] = n2;
            this.MINCODE[n] = this.HUFFCODE[n2];
            n2 += this.BITS[n] - 1 & 0xFF;
            this.MAXCODE[n] = this.HUFFCODE[n2++];
        }
        return;
    }

    private void generate_size_table() {
        int n = 1;
        int n2 = 0;
        for (int i = 1; i <= 16; ++i) {
            while (n <= (this.BITS[i - 1] & 0xFF)) {
                this.HUFFSIZE[n2++] = i;
                ++n;
            }
            n = 1;
        }
        this.HUFFSIZE[n2] = 0;
        this.LASTK = n2;
    }

    public void generateDecoderTables() {
        this.generate_size_table();
        this.generate_code_table();
        this.generate_decoder_tables();
    }

    public void generateEncoderTables() {
        this.generate_size_table();
        this.generate_code_table();
        this.order_codes();
    }

    public int[] getCodeTable() {
        return (int[])this.HUFFCODE.clone();
    }

    public int[] getEncoderCodeTable() {
        return (int[])this.EHUFCO.clone();
    }

    public int[] getEncoderSizeTable() {
        return (int[])this.EHUFSI.clone();
    }

    public int[] getMaxCodeTable() {
        return (int[])this.MAXCODE.clone();
    }

    public int[] getMinCodeTable() {
        return (int[])this.MINCODE.clone();
    }

    public int[] getValPTRTable() {
        return (int[])this.VALPTR.clone();
    }

    public byte[] getValueTable() {
        return (byte[])this.HUFFVAL.clone();
    }

    private void order_codes() {
        int n = 0;
        while (n < this.LASTK) {
            int n2 = this.HUFFVAL[n] & 0xFF;
            this.EHUFCO[n2] = this.HUFFCODE[n];
            this.EHUFSI[n2] = this.HUFFSIZE[n++];
        }
    }

    public void setBits(byte[] byArray) {
        this.BITS = byArray;
    }

    public void setValues(byte[] byArray) {
        this.HUFFVAL = byArray;
    }
}

