/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.ccitt;

import com.icafe4j.image.compression.ccitt.T4Code;
import java.util.HashMap;
import java.util.Map;

public enum T4WhiteCode implements T4Code
{
    CODE0(0, 8, 13568),
    CODE1(1, 6, 7168),
    CODE2(2, 4, 28672),
    CODE3(3, 4, Short.MIN_VALUE),
    CODE4(4, 4, -20480),
    CODE5(5, 4, -16384),
    CODE6(6, 4, -8192),
    CODE7(7, 4, -4096),
    CODE8(8, 5, -26624),
    CODE9(9, 5, -24576),
    CODE10(10, 5, 14336),
    CODE11(11, 5, 16384),
    CODE12(12, 6, 8192),
    CODE13(13, 6, 3072),
    CODE14(14, 6, -12288),
    CODE15(15, 6, -11264),
    CODE16(16, 6, -22528),
    CODE17(17, 6, -21504),
    CODE18(18, 7, 19968),
    CODE19(19, 7, 6144),
    CODE20(20, 7, 4096),
    CODE21(21, 7, 11776),
    CODE22(22, 7, 1536),
    CODE23(23, 7, 2048),
    CODE24(24, 7, 20480),
    CODE25(25, 7, 22016),
    CODE26(26, 7, 9728),
    CODE27(27, 7, 18432),
    CODE28(28, 7, 12288),
    CODE29(29, 8, 512),
    CODE30(30, 8, 768),
    CODE31(31, 8, 6656),
    CODE32(32, 8, 6912),
    CODE33(33, 8, 4608),
    CODE34(34, 8, 4864),
    CODE35(35, 8, 5120),
    CODE36(36, 8, 5376),
    CODE37(37, 8, 5632),
    CODE38(38, 8, 5888),
    CODE39(39, 8, 10240),
    CODE40(40, 8, 10496),
    CODE41(41, 8, 10752),
    CODE42(42, 8, 11008),
    CODE43(43, 8, 11264),
    CODE44(44, 8, 11520),
    CODE45(45, 8, 1024),
    CODE46(46, 8, 1280),
    CODE47(47, 8, 2560),
    CODE48(48, 8, 2816),
    CODE49(49, 8, 20992),
    CODE50(50, 8, 21248),
    CODE51(51, 8, 21504),
    CODE52(52, 8, 21760),
    CODE53(53, 8, 9216),
    CODE54(54, 8, 9472),
    CODE55(55, 8, 22528),
    CODE56(56, 8, 22784),
    CODE57(57, 8, 23040),
    CODE58(58, 8, 23296),
    CODE59(59, 8, 18944),
    CODE60(60, 8, 19200),
    CODE61(61, 8, 12800),
    CODE62(62, 8, 13056),
    CODE63(63, 8, 13312),
    CODE64(64, 5, -10240),
    CODE128(128, 5, -28672),
    CODE192(192, 6, 23552),
    CODE256(256, 7, 28160),
    CODE320(320, 8, 13824),
    CODE384(384, 8, 14080),
    CODE448(448, 8, 25600),
    CODE512(512, 8, 25856),
    CODE576(576, 8, 26624),
    CODE640(640, 8, 26368),
    CODE704(704, 9, 26112),
    CODE768(768, 9, 26240),
    CODE832(832, 9, 26880),
    CODE896(896, 9, 27008),
    CODE960(960, 9, 27136),
    CODE1024(1024, 9, 27264),
    CODE1088(1088, 9, 27392),
    CODE1152(1152, 9, 27520),
    CODE1216(1216, 9, 27648),
    CODE1280(1280, 9, 27776),
    CODE1344(1344, 9, 27904),
    CODE1408(1408, 9, 28032),
    CODE1472(1472, 9, 19456),
    CODE1536(1536, 9, 19584),
    CODE1600(1600, 9, 19712),
    CODE1664(1664, 6, 24576),
    CODE1728(1728, 9, 19840),
    CODE1792(1792, 11, 256),
    CODE1856(1856, 11, 384),
    CODE1920(1920, 11, 416),
    CODE1984(1984, 12, 288),
    CODE2048(2048, 12, 304),
    CODE2112(2112, 12, 320),
    CODE2176(2176, 12, 336),
    CODE2240(2240, 12, 352),
    CODE2304(2304, 12, 368),
    CODE2368(2368, 12, 448),
    CODE2432(2432, 12, 464),
    CODE2496(2496, 12, 480),
    CODE2560(2560, 12, 496),
    UNKNOWN(9999, 12, 0),
    EOL(-1, 12, 16),
    FILL_4_EOL(-2, 16, 1),
    FILL_3_EOL(-3, 15, 2),
    FILL_2_EOL(-4, 14, 4),
    FILL_1_EOL(-5, 13, 8);

    private static final Map<Integer, T4Code> runLenMap;
    private static final Map<Short, T4Code> codeMap;
    private final int runLen;
    private final int codeLen;
    private final short code;

    private T4WhiteCode(int n2, int n3, short s) {
        this.runLen = n2;
        this.codeLen = n3;
        this.code = s;
    }

    @Override
    public int getRunLen() {
        return this.runLen;
    }

    @Override
    public int getCodeLen() {
        return this.codeLen;
    }

    @Override
    public short getCode() {
        return this.code;
    }

    public static T4Code fromRunLen(int n) {
        T4Code t4Code = runLenMap.get(n);
        if (t4Code == null) {
            return UNKNOWN;
        }
        return t4Code;
    }

    public static T4Code fromCode(short s) {
        T4Code t4Code = codeMap.get(s);
        if (t4Code == null) {
            return UNKNOWN;
        }
        return t4Code;
    }

    static {
        runLenMap = new HashMap<Integer, T4Code>();
        codeMap = new HashMap<Short, T4Code>();
        for (T4WhiteCode t4WhiteCode : T4WhiteCode.values()) {
            runLenMap.put(t4WhiteCode.getRunLen(), t4WhiteCode);
            codeMap.put(t4WhiteCode.getCode(), t4WhiteCode);
        }
    }
}

