/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.bmp;

import com.icafe4j.image.bmp.BmpCompression;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.image.ImageMetadata;
import com.icafe4j.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMPTweaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPTweaker.class);

    private static void readHeader(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        DataTransferObject.access$002(dataTransferObject, new byte[14]);
        DataTransferObject.access$102(dataTransferObject, new byte[40]);
        inputStream.read(dataTransferObject.fileHeader);
        inputStream.read(dataTransferObject.infoHeader);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        ImageMetadata imageMetadata = new ImageMetadata();
        DataTransferObject dataTransferObject = new DataTransferObject();
        BMPTweaker.readHeader(inputStream, dataTransferObject);
        LOGGER.info("... BMP Image Inforamtion starts...");
        LOGGER.info("Image signature: {}", (Object)new String(dataTransferObject.fileHeader, 0, 2));
        LOGGER.info("File size: {} bytes", (Object)IOUtils.readInt(dataTransferObject.fileHeader, 2));
        LOGGER.info("Reserved1 (2 bytes): {}", (Object)IOUtils.readShort(dataTransferObject.fileHeader, 6));
        LOGGER.info("Reserved2 (2 bytes): {}", (Object)IOUtils.readShort(dataTransferObject.fileHeader, 8));
        LOGGER.info("Data offset: {}", (Object)IOUtils.readInt(dataTransferObject.fileHeader, 10));
        MetadataEntry metadataEntry = new MetadataEntry("BMP File Header", "Bitmap File Header", true);
        metadataEntry.addEntry(new MetadataEntry("Image signature", new String(dataTransferObject.fileHeader, 0, 2)));
        metadataEntry.addEntry(new MetadataEntry("File size", IOUtils.readInt(dataTransferObject.fileHeader, 2) + " bytes"));
        metadataEntry.addEntry(new MetadataEntry("Reserved1", IOUtils.readShort(dataTransferObject.fileHeader, 6) + ""));
        metadataEntry.addEntry(new MetadataEntry("Reserved2", IOUtils.readShort(dataTransferObject.fileHeader, 8) + ""));
        metadataEntry.addEntry(new MetadataEntry("Data-offset", "byte " + IOUtils.readInt(dataTransferObject.fileHeader, 10)));
        imageMetadata.addMetadataEntry(metadataEntry);
        LOGGER.info("Info header length: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 0));
        LOGGER.info("Image width: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 4));
        LOGGER.info("Image heigth: {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 8));
        String string = "";
        string = IOUtils.readInt(dataTransferObject.infoHeader, 8) > 0 ? "BOTTOM_UP" : "TOP_DOWN";
        MetadataEntry metadataEntry2 = new MetadataEntry("BMP Info Header", "Bitmap Information Header", true);
        metadataEntry2.addEntry(new MetadataEntry("Info-header-lengthen", IOUtils.readInt(dataTransferObject.infoHeader, 0) + " bytes"));
        metadataEntry2.addEntry(new MetadataEntry("Image-alignment", string));
        metadataEntry2.addEntry(new MetadataEntry("Number-of-planes", IOUtils.readShort(dataTransferObject.infoHeader, 12) + " planes"));
        metadataEntry2.addEntry(new MetadataEntry("Bits-per-pixel", IOUtils.readShort(dataTransferObject.infoHeader, 14) + " bits per pixel"));
        metadataEntry2.addEntry(new MetadataEntry("Compression", BmpCompression.fromInt(IOUtils.readInt(dataTransferObject.infoHeader, 16)).toString()));
        metadataEntry2.addEntry(new MetadataEntry("Compessed-image-size", IOUtils.readInt(dataTransferObject.infoHeader, 20) + " bytes"));
        metadataEntry2.addEntry(new MetadataEntry("Horizontal-resolution", IOUtils.readInt(dataTransferObject.infoHeader, 24) + " pixels/meter"));
        metadataEntry2.addEntry(new MetadataEntry("Vertical-resolution", IOUtils.readInt(dataTransferObject.infoHeader, 28) + " pixels/meter"));
        metadataEntry2.addEntry(new MetadataEntry("Colors-used", IOUtils.readInt(dataTransferObject.infoHeader, 32) + " colors used"));
        metadataEntry2.addEntry(new MetadataEntry("Important-colors", IOUtils.readInt(dataTransferObject.infoHeader, 36) + " important colors"));
        imageMetadata.addMetadataEntry(metadataEntry2);
        LOGGER.info("Image alignment: {}", (Object)string);
        LOGGER.info("Number of planes: {}", (Object)IOUtils.readShort(dataTransferObject.infoHeader, 12));
        LOGGER.info("BitCount (bits per pixel): {}", (Object)IOUtils.readShort(dataTransferObject.infoHeader, 14));
        LOGGER.info("Compression: {}", (Object)BmpCompression.fromInt(IOUtils.readInt(dataTransferObject.infoHeader, 16)));
        LOGGER.info("Image size (compressed size of image): {} bytes", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 20));
        LOGGER.info("Horizontal resolution (Pixels/meter): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 24));
        LOGGER.info("Vertical resolution (Pixels/meter): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 28));
        LOGGER.info("Colors used (number of actually used colors): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 32));
        LOGGER.info("Important colors (number of important colors): {}", (Object)IOUtils.readInt(dataTransferObject.infoHeader, 36));
        short s = IOUtils.readShort(dataTransferObject.infoHeader, 14);
        if (s <= 8) {
            BMPTweaker.readPalette(inputStream, dataTransferObject);
            LOGGER.info("Color map follows");
        }
        hashMap.put(MetadataType.IMAGE, imageMetadata);
        return hashMap;
    }

    private static void readPalette(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = IOUtils.readInt(dataTransferObject.infoHeader, 32);
        short s = IOUtils.readShort(dataTransferObject.infoHeader, 14);
        int n4 = IOUtils.readInt(dataTransferObject.fileHeader, 10);
        int n5 = n3 == 0 ? 1 << s : n3;
        byte[] byArray = new byte[n5 * 4];
        DataTransferObject.access$302(dataTransferObject, new int[n5]);
        IOUtils.readFully(inputStream, byArray);
        for (int i = 0; i < n5; ++i) {
            ((DataTransferObject)dataTransferObject).colorPalette[n++] = 0xFF000000 | byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16;
            n2 += 4;
        }
        IOUtils.skipFully(inputStream, n4 - n5 * 4 - 54);
    }

    private BMPTweaker() {
    }

    private static class DataTransferObject {
        private byte[] fileHeader;
        private byte[] infoHeader;
        private int[] colorPalette;

        private DataTransferObject() {
        }

        static /* synthetic */ byte[] access$002(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.fileHeader = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$102(DataTransferObject dataTransferObject, byte[] byArray) {
            dataTransferObject.infoHeader = byArray;
            return byArray;
        }

        static /* synthetic */ int[] access$302(DataTransferObject dataTransferObject, int[] nArray) {
            dataTransferObject.colorPalette = nArray;
            return nArray;
        }
    }
}

