/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image;

import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.PeekHeadInputStream;
import com.icafe4j.io.RandomAccessInputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImageIO {
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;

    public static ImageReader getReader(ImageType imageType) {
        return imageType.getReader();
    }

    public static ImageReader getReader(PeekHeadInputStream peekHeadInputStream) {
        ImageType imageType = ImageType.UNKNOWN;
        try {
            imageType = IMGUtils.guessImageType(peekHeadInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (imageType != ImageType.UNKNOWN) {
            return ImageIO.getReader(imageType);
        }
        return null;
    }

    public static ImageWriter getWriter(ImageType imageType) {
        return imageType.getWriter();
    }

    public static BufferedImage read(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedImage bufferedImage = ImageIO.read(fileInputStream);
        fileInputStream.close();
        return bufferedImage;
    }

    public static BufferedImage read(InputStream inputStream) throws Exception {
        ImageType imageType = null;
        boolean bl = false;
        if (inputStream instanceof RandomAccessInputStream) {
            imageType = IMGUtils.guessImageType((RandomAccessInputStream)inputStream);
        } else {
            inputStream = new PeekHeadInputStream(inputStream, 4);
            imageType = IMGUtils.guessImageType((PeekHeadInputStream)inputStream);
            bl = true;
        }
        BufferedImage bufferedImage = null;
        if (imageType != ImageType.UNKNOWN) {
            bufferedImage = ImageIO.getReader(imageType).read(inputStream);
        }
        if (bl) {
            ((PeekHeadInputStream)inputStream).shallowClose();
        }
        return bufferedImage;
    }

    public static BufferedImage read(String string) throws Exception {
        return ImageIO.read(new File(string));
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream, ImageType imageType) throws Exception {
        ImageIO.write(bufferedImage, outputStream, imageType, ImageParam.DEFAULT_IMAGE_PARAM);
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream, ImageType imageType, ImageParam imageParam) throws Exception {
        ImageWriter imageWriter = ImageIO.getWriter(imageType);
        if (imageWriter != null) {
            imageWriter.setImageParam(imageParam);
            imageWriter.write(bufferedImage, outputStream);
        }
    }

    private ImageIO() {
    }
}

